package com.youqian.api.enums.goods;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2020/6/11.
 */
@Getter
public enum ColorOrSizeEnum {

    OTHER((byte)0,"other","其他属性"),
    COLOR((byte)1,"color","颜色"),
    SIZE((byte)2,"size","尺寸");

    private final Byte code;

    private final String type;

    private final String desc;

    ColorOrSizeEnum(Byte code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static ColorOrSizeEnum getByCode(Byte code) {
        return Stream.of(ColorOrSizeEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(OTHER);
    }

    public static ColorOrSizeEnum getByType(String type) {
        return Stream.of(ColorOrSizeEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(OTHER);
    }
}

