package com.youqian.api.enums.goods;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2020/11/7.
 */
@Getter
public enum GoodsPicEnum {

    IMAGE(1, "image", "图片"),
    VIDEO(2, "video", "视频")
    ;

    private final Integer code;

    private final String  type;

    private final String  desc;

    GoodsPicEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static GoodsPicEnum getByCode(Integer code) {
        return Stream.of(GoodsPicEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(IMAGE);
    }

    public static GoodsPicEnum getByType(String type) {
        return Stream.of(GoodsPicEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(IMAGE);
    }
}