package com.youqian.api.params.wms;

import com.youqian.api.params.wms.sonnodes.OrderGoodsParam;
import com.youqian.api.params.wms.sonnodes.OrderSkuParam;
import com.youqian.api.request.Operator;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

@Data
public class OperateOrderParam  extends Operator implements Serializable {

    /**
     * 本次操作类型
     *  1-入库 2-预定库存 4-取消预订 7-订单修改 8-出库 16-盘点
     */
    @NotNull(message = "库存操作类型不能为空")
    @Max(value= 16,message = "操作类型为1-16位")
    @Min(value= 1,message = "操作类型为1-16位")
    private Byte type;

    /**
     * 本次操作商品集合
     */
    @Valid
    @NotEmpty(message = "库存操作商品不能为空")
    private List<OrderGoodsParam> goodsList;

    /**
     * 针对于订单修改和退单的操作 要带上历史数据
     * 前端调用可为空
     */
    private List<OrderGoodsParam> old;

    /**
     * 订单号操作同步
     */
    private String orderNo;

    /**
     * 订单操作同步编号
     */
    private long orderId;

    /**
     * 操作人编号
     */
    private long emloyeeId;

    /**
     * 盘点时的备注
     */
    private String comment;
}
