package com.youqian.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.youqian.api.dto.ExportDto;
import com.youqian.api.dto.shopgoods.ShopGoodsDetail;
import com.youqian.api.dto.shopgoods.ShopGoodsDto;
import com.youqian.api.dto.shopgoods.ShopGoodsPicDto;
import com.youqian.api.dto.shopgoods.custom.GoodsSkuTagDto;
import com.youqian.api.dto.shopgoods.custom.GoodsWholeInfoV2;
import com.youqian.api.dto.shopgoods.custom.back.GoodsSkuTagBackDto;
import com.youqian.api.dto.shopgoods.custom.tag.GoodsTagAndGoodsCountDto;
import com.youqian.api.params.goods.AddGoodsParamV2;
import com.youqian.api.params.goods.GoodsListGetParamV2;
import com.youqian.api.params.goods.GoodsListParam;
import com.youqian.api.params.goods.LiveGoodsListParam;
import com.youqian.api.params.goods.OperateGoodsParam;
import com.youqian.api.params.goods.UpdateGoodsParam;
import com.youqian.api.response.GoodsDataResult;
import com.youqian.api.response.GoodsListResult;
import com.youqian.api.response.LiveGoodsLResult;
import com.youqian.auth.api.exception.BizException;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @author tengtuox
 * @date 2020/4/21
 * @description
 */
@AdvancedFeignClient
public interface RemoteGoodsService {

    /**
     * 批量查询商品
     *
     * @param goodsIds goodsIds
     * @return List<ShopGoodsDto>
     */
    List<ShopGoodsDto> batchGet(Collection<Long> goodsIds) throws BizException;

    /**
     * 根据商品ID查商品
     *
     * @param goodsId goodsId
     * @return ShopGoodsDto
     */
    ShopGoodsDto selectByGoodsId(Long goodsId) throws BizException;

    /**
     * 查询商品详情
     *
     * @param goodsId goodsId
     * @return ShopGoodsDetail
     */
    ShopGoodsDetail selectOneDetail(Long goodsId) throws BizException;

    /**
     * 添加商品-后台管理
     * @param operateGoodsParam 商品列表请求参数
     */
    void addGoods(OperateGoodsParam operateGoodsParam) throws BizException;

    /**
     * 更新商品-后台管理
     * @param operateGoodsParam 商品列表请求参数
     */
    void updateGoods(OperateGoodsParam operateGoodsParam) throws BizException;

    /**
     * 商品列表-后台管理
     */
    List<GoodsListResult> goodsList(GoodsListParam goodsListParam) throws BizException;

    /**
     * 商品列表-后台管理
     */
    Integer countGoodsList(GoodsListParam goodsListParam) throws BizException;

    /**
     * 标签列表
     */
    List<GoodsTagAndGoodsCountDto> selectByTagList(Long merchantId);

    /**
     * 批量查询商品的组图
     */
    List<ShopGoodsPicDto> selectShopGoodsPicList(Collection<Long> goodsIds);

    /**
     * 观众-商品列表
     */
    LiveGoodsLResult selectLiveGoodsList(LiveGoodsListParam liveGoodsListParam);

    /**
     * 添加商品
     * @param operateGoodsParam 商品列表请求参数
     */
    void addGoodsV2(AddGoodsParamV2 operateGoodsParam);

    /**
     * 更新商品
     * @param operateGoodsParam 商品列表请求参数
     */
    void updateGoodsV2(UpdateGoodsParam operateGoodsParam);

    /**
     * 获取商品详情
     * @param shopGoodsId 商品id
     */
    GoodsWholeInfoV2 getGoodsInfoV2(Long shopGoodsId);

    /**
     * 获取商品列表
     * @param goodsListGetParam 商品列表请求参数
     * @return 商品vo分页数据
     */
    GoodsSkuTagBackDto listV2(GoodsListGetParamV2 goodsListGetParam);

    /**
     * 删除商品
     * @param operateGoodsParam 商品列表请求参数
     */
    void delGoods(OperateGoodsParam operateGoodsParam);

    /**
     * 上传excel
     * @param leading 解析后的表格列表
     */
    ExportDto uploadExcel(List<Map<String, Object>> leading,Integer type,Long merchantId);

    /**
     * 商品列表
     */
    List<GoodsDataResult> liveGoodsList(List<Long> goodsIds);

    /**
     * 上传商品图片
     * @param url 地址
     * @param goodsId 商品ID
     * @param merchantId 商户ID
     */
    boolean uploadGoods(String url,Long goodsId,Long merchantId);
}
