package com.youqian.api.request;

import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.util.List;

@Data
public class CreateOrderReportRequest {
    /**
     * 订单列表ID
     */
    private List<GoodsSkuRequest> goodsSku;

    /**
     * 用户ID
     */
    private Long userId;
    /**
     * 商户ID
     */
    @Min(1)
    @NotNull(message = "商户Id不能为空")
    private Long merchantId;

    /**
     * 直播间ID
     */
    private Long liveRoomId;

    /**
     * token
     */
    private Long token;

}
