package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
public class CustomerIntentPriceUpdateRequest {

    /**
     * 客户的用户ID
     */
    @NotNull(message = "用户ID不能空")
    private Long customerUserId;

    /**
     * 商品报价ID
     */
    private Long customerIntentItemId;

    /**
     * 直播间ID
     */
    @NotNull(message = "直播间ID不能为空")
    private Long liveRoomId;

    /**
     * 商品ID
     */
    @NotNull(message = "商品ID不能为空")
    private Long goodsId;

    /**
     * 价格
     */
    @NotBlank(message = "价格不能为空")
    private String price;

    /**
     * 询价拓展ID
     */
    @NotNull(message = "询价ID不能为空")
    private Long customerIntentExtId;

    /**
     * 操作人UserId
     */
    private Long operatorUserId;
}
