package com.youqian.api.request;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author tengtuox
 * @date 2020/3/30
 * @description
 */
@Data
public class OrderEvent implements Serializable {

    /**
     * 事件类型
     * @see com.youqian.api.enums.EnumOrderEvent
     */
    private Byte eventType;

    /**
     * 事件时间
     */
    private Date eventTime = new Date();

    /**
     * 订单编号
     */
    private Long orderId;

    /**
     * 回款金额
     */
    private BigDecimal backMoney;

    /**
     * 是否强制关闭收款流程
     */
    private Boolean forceEndMoney = Boolean.FALSE;

    /**
     * 消息ID
     */
    private String uuid;

}
