package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/4/8
 * @description
 */
@Data
public class UpdateUserAddressV1Request implements Serializable {

    @Min(1)
    @NotNull
    @ApiModelProperty(value = "业务ID", required = true)
    private Long userAddressId;

    @NotBlank
    @ApiModelProperty(value = "收货人名称", required = true)
    private String name;

    @NotBlank
    @ApiModelProperty(value = "收货人手机号码", required = true)
    private String mobile;

    @NotBlank
    @ApiModelProperty(value = "收货地址", required = true)
    private String address;

    @NotNull
    @Min(1)
    @ApiModelProperty(value = "省", required = true)
    private Integer province;

    @NotNull
    @Min(1)
    @ApiModelProperty(value = "市", required = true)
    private Integer city;

    @NotNull
    @Min(1)
    @ApiModelProperty(value = "区", required = true)
    private Integer area;

    @ApiModelProperty(value = "省市区",required = true)
    private String shortAddress;

    @NotNull
    @ApiModelProperty(value = "是否默认", required = true)
    private Byte hasDefault;

}
