package com.youqian.api.request;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class UserEnquiryRequest {
    /**
     * 直播间ID
     */
    @NotNull(message = "直播间ID不能为空")
    private Long liveRoomId;
    /**
     * 商品ID
     */
    @NotNull(message = "商品ID不能为空")
    private Long goodsId;
    /**
     * 用户ID(前端忽略)
     */
    private Long userId;
    /**
     * 操作时间-前端忽略
     */
    private Date time;

    /**
     * 类型 1-直播中 2-回看
     */
    private Integer space;

    /**
     * token-前端忽略
     */
    private Long token;
}
