package com.youqian.api.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
public class UserListRequest extends PageRequest implements Serializable {
    /**
     * 商户ID
     */
    private Long merchantId;
    /**
     * 姓名手机号
     */
    private String param;
    /**
     * 类型
     */
    private Byte type;
    /**
     * 用户ID
     */
    private List<Long> userIds;

    /**
     * 标签 1-关注店铺 2-累计订单
     */
    private Integer tab;

    /**
     * 排序 1-降序 0-升序
     */
    private Integer sort;
}
