package com.youqian.api.response;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.youqian.api.util.BigDecimalSerializer;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author tengtuox
 * @date 2020/9/22
 * @description
 */
@Data
public class OrderSkuStatisticsResult implements Serializable {

    /**
     * 商户ID
     */
    private Long merchantId;

    /**
     * 商品ID
     */
    private Long goodsId;

    /**
     * 商品款号
     */
    private String shortName;

    /**
     * SKU ID
     */
    private Long skuId;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 单位
     */
    private String unit;

    /**
     * SKU名称
     */
    private String skuName;

    /**
     * 商品规格货号
     */
    private String goodsSpecCode;

    /**
     * 开单数量
     */
    private Integer openOrderCount = 0;

    /**
     * 商品出售数量
     */
    private Integer skuCount = 0;

    /**
     * 商品出售总价
     */
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal skuMoney = BigDecimal.ZERO;

    /**
     * 购买客户数量
     */
    private Integer customerCount = 0;

}
