package com.youqian.api.response;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.youqian.api.util.BigDecimalSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author tengtuox
 * @date 2020/9/22
 * @description
 */
@Data
public class OrderStatisticsResult implements Serializable {

    @ApiModelProperty("今日开单数量")
    private Integer todayOpenOrderCount = 0;

    @ApiModelProperty("昨日开单数量")
    private Integer yesterdayOpenOrderCount = 0;

    @ApiModelProperty("本月开单数量")
    private Integer monthOpenOrderCount = 0;

    @ApiModelProperty("今日开单金额")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal todayOpenOrderMoney = BigDecimal.ZERO;

    @ApiModelProperty("昨日开单金额")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal yesterdayOpenOrderMoney = BigDecimal.ZERO;

    @ApiModelProperty("本月开单金额")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal monthOpenOrderMoney = BigDecimal.ZERO;

    @ApiModelProperty("今日发货数量")
    private Integer todayDeliveryCount = 0;

    @ApiModelProperty("昨日发货数量")
    private Integer yesterdayDeliveryCount = 0;

    @ApiModelProperty("本月发货数量")
    private Integer monthDeliveryCount = 0;

    @ApiModelProperty("今日发货金额")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal todayDeliverMoney = BigDecimal.ZERO;

    @ApiModelProperty("昨日发货金额")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal yesterdayDeliverMoney = BigDecimal.ZERO;

    @ApiModelProperty("本月发货金额")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal monthDeliverMoney = BigDecimal.ZERO;

    @ApiModelProperty("今日回款金额")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal todayMoneyBack = BigDecimal.ZERO;

    @ApiModelProperty("昨日回款金额")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal yesterdayMoneyBack = BigDecimal.ZERO;

    @ApiModelProperty("本月回款金额")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal monthMoneyBack = BigDecimal.ZERO;

}
