/*
 * Decompiled with CFR 0.152.
 */
package com.zcoson.atman.plugin.web.filter;

import com.zcoson.atman.core.Atman;
import com.zcoson.atman.core.AtmanConfig;
import com.zcoson.atman.core.utils.ServletParamUtil;
import com.zcoson.atman.core.utils.StringUtils;
import com.zcoson.atman.core.utils.UUIDUtils;
import com.zcoson.atman.plugin.web.servlet.http.TraceLogServletRequestWrapper;
import io.opentracing.BaseSpan;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmanServletFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtmanServletFilter.class);
    private static final String SERVICE_LABEL = "SERVLET";
    private String[] exclusions;

    public void init(FilterConfig filterConfig) throws ServletException {
        String exclusion = filterConfig.getInitParameter("exclusions");
        if (null == exclusion || 0 == exclusion.trim().length()) {
            return;
        }
        this.exclusions = exclusion.split(",");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        if (!(req instanceof HttpServletRequest)) {
            chain.doFilter(req, resp);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)req;
        if (this.isExclusions(request.getRequestURI())) {
            chain.doFilter(req, resp);
            return;
        }
        Span span = null;
        try {
            String traceValue = this.getTraceValue(request);
            span = Atman.newSpan((String)request.getRequestURI(), (SpanContext)Atman.extract((String)traceValue));
            span.setTag("span.type", AtmanConfig.ServiceType.HTTP.getCode());
            span.setTag("span.label", SERVICE_LABEL);
            Tags.SPAN_KIND.set((BaseSpan)span, "server");
            Tags.PEER_HOSTNAME.set((BaseSpan)span, request.getLocalName());
            this.handlerHeader(span, request);
            this.handlerParameter(span, request);
        }
        catch (Throwable t) {
            LOGGER.warn("SERVLETBefore", t);
        }
        try {
            chain.doFilter(this.handlerPayload(span, request), resp);
        }
        catch (Throwable t) {
            LOGGER.warn("SERVLETParameter", t);
            chain.doFilter(req, resp);
        }
        finally {
            if (null != span) {
                span.finish();
            }
        }
    }

    public void destroy() {
    }

    private String getTraceValue(HttpServletRequest request) {
        String traceValue = request.getHeader("atman-trace");
        if (StringUtils.isEmpty((String)traceValue)) {
            return UUIDUtils.randomString();
        }
        return traceValue;
    }

    private void handlerHeader(Span span, HttpServletRequest request) {
        Enumeration names = request.getHeaderNames();
        if (null == names) {
            return;
        }
        String name = null;
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            if (ServletParamUtil.excludeHeaderName((String)name)) continue;
            span.log("header." + ServletParamUtil.getParameterName((String)name), (Object)request.getHeader(name));
        }
    }

    private void handlerParameter(Span span, HttpServletRequest request) {
        Map parameter = request.getParameterMap();
        if (null == parameter || 0 == parameter.size()) {
            return;
        }
        for (Map.Entry entry : parameter.entrySet()) {
            span.log("parameter." + ServletParamUtil.getParameterName((String)((String)entry.getKey())), (Object)ServletParamUtil.getParameterValue((String[])((String[])entry.getValue())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServletRequest handlerPayload(Span span, HttpServletRequest request) {
        TraceLogServletRequestWrapper wrapper = null;
        try {
            wrapper = new TraceLogServletRequestWrapper(request);
            Map headerMap = (Map)AtmanConfig.GSON.fromJson(wrapper.getBody(), Map.class);
            if (null == headerMap || 0 == headerMap.size()) {
                HttpServletRequest httpServletRequest = request;
                return httpServletRequest;
            }
            for (Map.Entry entry : headerMap.entrySet()) {
                span.log("parameter." + (String)entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            LOGGER.warn("SERVLETPayload", (Throwable)e);
        }
        finally {
            return wrapper;
        }
    }

    private boolean isExclusions(String uri) {
        if (null == this.exclusions || 0 == this.exclusions.length) {
            return false;
        }
        if (null == uri) {
            return false;
        }
        if (0 == (uri = uri.trim()).length()) {
            return false;
        }
        for (String ex : this.exclusions) {
            if (!uri.startsWith(ex = ex.trim()) && !uri.endsWith(ex)) continue;
            return true;
        }
        return false;
    }
}

