/*
 * Decompiled with CFR 0.152.
 */
package com.zcoson.atman.plugin.web.servlet.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.util.StreamUtils;

public class TraceLogServletRequestWrapper
extends HttpServletRequestWrapper {
    private final byte[] body;

    public TraceLogServletRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        this.body = StreamUtils.copyToByteArray((InputStream)request.getInputStream());
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public ServletInputStream getInputStream() throws IOException {
        return new RequestBodyCachingInputStream(this.body);
    }

    public String getBody() {
        return new String(this.body, Charset.forName("UTF-8"));
    }

    private class RequestBodyCachingInputStream
    extends ServletInputStream {
        private byte[] body;
        private int lastIndexRetrieved = -1;
        private ReadListener listener;

        public RequestBodyCachingInputStream(byte[] body) {
            this.body = body;
        }

        public int read() throws IOException {
            if (this.isFinished()) {
                return -1;
            }
            byte i = this.body[this.lastIndexRetrieved + 1];
            ++this.lastIndexRetrieved;
            if (this.isFinished() && this.listener != null) {
                try {
                    this.listener.onAllDataRead();
                }
                catch (IOException e) {
                    this.listener.onError((Throwable)e);
                    throw e;
                }
            }
            return i;
        }

        public boolean isFinished() {
            return this.lastIndexRetrieved == this.body.length - 1;
        }

        public boolean isReady() {
            return this.isFinished();
        }

        public void setReadListener(ReadListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("listener cann not be null");
            }
            if (this.listener != null) {
                throw new IllegalArgumentException("listener has been set");
            }
            this.listener = listener;
            if (!this.isFinished()) {
                try {
                    listener.onAllDataRead();
                }
                catch (IOException e) {
                    listener.onError((Throwable)e);
                }
            } else {
                try {
                    listener.onAllDataRead();
                }
                catch (IOException e) {
                    listener.onError((Throwable)e);
                }
            }
        }

        public int available() throws IOException {
            return this.body.length - this.lastIndexRetrieved - 1;
        }

        public void close() throws IOException {
            this.lastIndexRetrieved = this.body.length - 1;
            this.body = null;
        }
    }
}

