/*
 * Decompiled with CFR 0.152.
 */
package io.easy.cache.redis.springdata;

import io.easy.cache.core.CacheConfigException;
import io.easy.cache.core.CacheGetResult;
import io.easy.cache.core.CacheResult;
import io.easy.cache.core.CacheResultCode;
import io.easy.cache.core.CacheValueHolder;
import io.easy.cache.core.MultiGetResult;
import io.easy.cache.core.external.AbstractExternalCache;
import io.easy.cache.redis.springdata.Hessian2SerializationRedisSerializer;
import io.easy.cache.redis.springdata.RedisSpringDataCacheConfig;
import io.easy.cache.util.UUIDUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.serializer.RedisSerializer;
import redis.clients.jedis.Jedis;

public class RedisSpringDataCache<K, V>
extends AbstractExternalCache<K, V> {
    private static final Logger log = LoggerFactory.getLogger(RedisSpringDataCache.class);
    private RedisConnectionFactory connectionFactory;
    private RedisSerializer<Object> serializer = new Hessian2SerializationRedisSerializer();
    private static final String COMPARE_AND_DELETE = "if redis.call('get',KEYS[1]) == ARGV[1]\nthen\n    return redis.call('del',KEYS[1])\nelse\n    return 0\nend";

    public RedisSpringDataCache(RedisSpringDataCacheConfig<K, V> config) {
        super(config);
        this.connectionFactory = config.getConnectionFactory();
        if (this.connectionFactory == null) {
            throw new CacheConfigException("connectionFactory is required");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheGetResult<V> doGet(K key) {
        RedisConnection con = null;
        try {
            con = this.connectionFactory.getConnection();
            byte[] newKey = this.buildKey(key);
            byte[] resultBytes = con.get(newKey);
            if (resultBytes != null) {
                CacheValueHolder holder = (CacheValueHolder)this.serializer.deserialize(resultBytes);
                CacheGetResult cacheGetResult = super.parseHolderResult(holder);
                return cacheGetResult;
            }
            CacheGetResult cacheGetResult = CacheGetResult.NOT_EXISTS_WITHOUT_MSG;
            return cacheGetResult;
        }
        catch (Exception ex) {
            this.logError("GET", key, ex);
            CacheGetResult cacheGetResult = new CacheGetResult((Throwable)ex);
            return cacheGetResult;
        }
        finally {
            this.closeConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiGetResult<K, V> doGetAll(Set<? extends K> keys) {
        RedisConnection con = null;
        try {
            con = this.connectionFactory.getConnection();
            ArrayList<K> keyList = new ArrayList<K>(keys);
            byte[][] newKeys = (byte[][])keyList.stream().map(k -> this.buildKey(k)).toArray(x$0 -> new byte[x$0][]);
            HashMap<K, CacheGetResult> resultMap = new HashMap<K, CacheGetResult>();
            if (newKeys.length > 0) {
                List mgetResults = con.mGet(newKeys);
                for (int i = 0; i < mgetResults.size(); ++i) {
                    Object value = mgetResults.get(i);
                    K key = keyList.get(i);
                    if (value != null) {
                        CacheValueHolder holder = (CacheValueHolder)this.serializer.deserialize((byte[])value);
                        if (System.currentTimeMillis() >= holder.getExpireTime()) {
                            resultMap.put(key, CacheGetResult.EXPIRED_WITHOUT_MSG);
                            continue;
                        }
                        CacheGetResult r = new CacheGetResult(CacheResultCode.SUCCESS, null, holder);
                        resultMap.put(key, r);
                        continue;
                    }
                    resultMap.put(key, CacheGetResult.NOT_EXISTS_WITHOUT_MSG);
                }
            }
            MultiGetResult multiGetResult = new MultiGetResult(CacheResultCode.SUCCESS, null, resultMap);
            return multiGetResult;
        }
        catch (Exception ex) {
            this.logError("doGetAll", "keys(" + keys.size() + ")", ex);
            MultiGetResult multiGetResult = new MultiGetResult((Throwable)ex);
            return multiGetResult;
        }
        finally {
            this.closeConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheResult doPut(K key, V value) {
        if (value == null && !this.config().isCacheNullValue()) {
            return CacheResult.SUCCESS_WITHOUT_MSG;
        }
        RedisConnection con = null;
        try {
            con = this.connectionFactory.getConnection();
            CacheValueHolder holder = new CacheValueHolder(value, this.config().getExpireAfterWriteInMillis());
            byte[] keyBytes = this.buildKey(key);
            byte[] valueBytes = this.serializer.serialize((Object)holder);
            con.pSetEx(keyBytes, this.config().getExpireAfterWriteInMillis(), valueBytes);
            CacheResult cacheResult = CacheResult.SUCCESS_WITHOUT_MSG;
            return cacheResult;
        }
        catch (Exception ex) {
            this.logError("PUT", key, ex);
            CacheResult cacheResult = new CacheResult((Throwable)ex);
            return cacheResult;
        }
        finally {
            this.closeConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheResult doPutALL(Map<? extends K, ? extends V> map) {
        RedisConnection con = null;
        try {
            con = this.connectionFactory.getConnection();
            int failCount = 0;
            for (Map.Entry<K, V> en : map.entrySet()) {
                try {
                    CacheValueHolder holder = new CacheValueHolder(en.getValue(), this.config().getExpireAfterWriteInMillis());
                    byte[] valueBytes = this.serializer.serialize((Object)holder);
                    con.pSetEx(this.buildKey(en.getKey()), this.config().getExpireAfterWriteInMillis(), valueBytes);
                }
                catch (Exception e) {
                    log.error("pSetEx error", (Throwable)e);
                    ++failCount;
                }
            }
            CacheResult cacheResult = failCount == 0 ? CacheResult.SUCCESS_WITHOUT_MSG : (failCount == map.size() ? CacheResult.FAIL_WITHOUT_MSG : CacheResult.PART_SUCCESS_WITHOUT_MSG);
            return cacheResult;
        }
        catch (Exception ex) {
            this.logError("PUT_ALL", "map(" + map.size() + ")", ex);
            CacheResult cacheResult = new CacheResult((Throwable)ex);
            return cacheResult;
        }
        finally {
            this.closeConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheResult doInvalidate(K key) {
        RedisConnection con = null;
        try {
            con = this.connectionFactory.getConnection();
            byte[] keyBytes = this.buildKey(key);
            Long result = con.del((byte[][])new byte[][]{keyBytes});
            if (result == null) {
                CacheResult cacheResult = new CacheResult(CacheResultCode.FAIL, String.format("result: %s", result));
                return cacheResult;
            }
            if (result == 1L) {
                CacheResult cacheResult = CacheResult.SUCCESS_WITHOUT_MSG;
                return cacheResult;
            }
            if (result == 0L) {
                CacheResult cacheResult = new CacheResult(CacheResultCode.NOT_EXISTS, null);
                return cacheResult;
            }
            CacheResult cacheResult = CacheResult.FAIL_WITHOUT_MSG;
            return cacheResult;
        }
        catch (Exception ex) {
            this.logError("invalidate", key, ex);
            CacheResult cacheResult = new CacheResult((Throwable)ex);
            return cacheResult;
        }
        finally {
            this.closeConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheResult doInvalidateAll(Set<? extends K> keys) {
        RedisConnection con = null;
        try {
            con = this.connectionFactory.getConnection();
            byte[][] newKeys = (byte[][])keys.stream().map(k -> this.buildKey(k)).toArray(len -> new byte[keys.size()][]);
            Long result = con.del(newKeys);
            if (result != null) {
                CacheResult cacheResult = CacheResult.SUCCESS_WITHOUT_MSG;
                return cacheResult;
            }
            CacheResult cacheResult = new CacheResult(CacheResultCode.FAIL, String.format("result: %s", result));
            return cacheResult;
        }
        catch (Exception ex) {
            this.logError("InvalidateAll", String.format("keys(%s)", keys.size()), ex);
            CacheResult cacheResult = new CacheResult((Throwable)ex);
            return cacheResult;
        }
        finally {
            this.closeConnection(con);
        }
    }

    public byte[] buildKey(K key) {
        if (key instanceof byte[]) {
            return (byte[])key;
        }
        return this.serializer.serialize(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryLockAndRun(String key, long expireSeconds, int maxRetryTimes, Runnable action) {
        String value = UUIDUtils.createUUID();
        RedisConnection con = null;
        try {
            int maxTimes = maxRetryTimes + 1;
            con = this.connectionFactory.getConnection();
            Jedis jedis = (Jedis)con.getNativeConnection();
            for (int i = 0; i < maxTimes; ++i) {
                String status = jedis.set(key, value, "nx", "ex", expireSeconds);
                if ("OK".equals(status)) {
                    action.run();
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (Thread.currentThread().isInterrupted()) break;
            }
            this.closeConnection(con);
        }
        catch (Exception e) {
            try {
                this.logError("tryLockAndRun", key, e);
                this.closeConnection(con);
            }
            catch (Throwable throwable) {
                this.closeConnection(con);
                throw throwable;
            }
        }
        this.unLock(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unLock(String key, String value) {
        RedisConnection con = null;
        try {
            con = this.connectionFactory.getConnection();
            Jedis jedis = (Jedis)con.getNativeConnection();
            List<String> keys = Collections.singletonList(key);
            List<String> args = Collections.singletonList(value);
            jedis.eval(COMPARE_AND_DELETE, keys, args);
        }
        catch (Exception e) {
            this.logError("unLock", key, e);
        }
        finally {
            this.closeConnection(con);
        }
    }

    private void closeConnection(RedisConnection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception ex) {
            log.error("RedisConnection close fail: {}, {}", (Object)ex.getMessage(), (Object)ex.getClass().getName());
        }
    }
}

