package io.easy.cache.autoconfigure;

import io.easy.cache.anno.support.AutoConfigureBeans;
import io.easy.cache.core.CacheBuilder;
import io.easy.cache.core.CacheConfigException;
import io.easy.cache.redis.springdata.RedisSpringDataCacheBuilder;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;

import java.util.Map;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019-10-28 10:36
 * @descript:
 * @version: 1.0
 */
@Configuration
@AutoConfigureBefore(RedisAutoConfiguration.class)
@ConditionalOnBean(RedisConnectionFactory.class)
public class RedisSpringDataAutoConfiguration {

    @Bean
    public SpringDataRedisAutoInit springDataRedisAutoInit() {
        return new SpringDataRedisAutoInit();
    }

    public static class SpringDataRedisAutoInit  implements ApplicationContextAware, InitializingBean {

        private ApplicationContext applicationContext;

        private CacheBuilder initCache() {
            Map<String, RedisConnectionFactory> beans = applicationContext.getBeansOfType(RedisConnectionFactory.class);
            if (beans == null || beans.isEmpty()) {
                throw new CacheConfigException("no RedisConnectionFactory in spring context");
            }
            RedisConnectionFactory factory = beans.values().iterator().next();
            if (beans.size() > 1) {
                // TODO valid
            }
            return RedisSpringDataCacheBuilder.createBuilder().connectionFactory(factory);
        }

        @Override
        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.applicationContext = applicationContext;
        }

        @Override
        public void afterPropertiesSet() {
            AutoConfigureBeans autoConfigureBeans = applicationContext.getBean(AutoConfigureBeans.class);
            autoConfigureBeans.setRemoteCacheBuilders(initCache());
        }
    }
}
