/*
 * Decompiled with CFR 0.152.
 */
package io.elasticjob.autoconfigure;

import io.elasticjob.autoconfigure.ZookeeperProperties;
import io.elasticjob.autoconfigure.parser.ElasticJobConfParser;
import io.elasticjob.lite.reg.zookeeper.ZookeeperConfiguration;
import io.elasticjob.lite.reg.zookeeper.ZookeeperRegistryCenter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={ZookeeperProperties.class})
public class ElasticJobAutoConfiguration {
    public static final String ZK_CLIENT_FOR_ELASTIC_JOB_BEAN_NAME = "zookeeperRegistryCenterForElasticJob";
    @Autowired
    private ZookeeperProperties zookeeperProperties;
    @Value(value="${spring.application.name}")
    private String currentAppName;

    @Bean(initMethod="init", name={"zookeeperRegistryCenterForElasticJob"})
    @ConditionalOnMissingBean(name={"zookeeperRegistryCenterForElasticJob"})
    public ZookeeperRegistryCenter zookeeperRegistryCenter() {
        if (StringUtils.isBlank((CharSequence)this.zookeeperProperties.getServerLists())) {
            throw new IllegalStateException("if you import elastic-job-spring-boot-starter, you must at least config this property: [elastic.job.zk.serverLists] to point to your zookeeper address");
        }
        ZookeeperConfiguration zkConfig = new ZookeeperConfiguration(this.zookeeperProperties.getServerLists(), (String)StringUtils.defaultIfBlank((CharSequence)this.zookeeperProperties.getNamespace(), (CharSequence)("elastic-job/" + this.currentAppName)));
        zkConfig.setBaseSleepTimeMilliseconds(this.zookeeperProperties.getBaseSleepTimeMilliseconds());
        zkConfig.setConnectionTimeoutMilliseconds(this.zookeeperProperties.getConnectionTimeoutMilliseconds());
        zkConfig.setDigest(this.zookeeperProperties.getDigest());
        zkConfig.setMaxRetries(this.zookeeperProperties.getMaxRetries());
        zkConfig.setMaxSleepTimeMilliseconds(this.zookeeperProperties.getMaxSleepTimeMilliseconds());
        zkConfig.setSessionTimeoutMilliseconds(this.zookeeperProperties.getSessionTimeoutMilliseconds());
        return new ZookeeperRegistryCenter(zkConfig);
    }

    @Bean
    public ElasticJobConfParser elasticJobConfParser() {
        return new ElasticJobConfParser();
    }
}

