/*
 * Decompiled with CFR 0.152.
 */
package io.elasticjob.autoconfigure.parser;

import io.elasticjob.autoconfigure.annotation.ElasticJob;
import io.elasticjob.autoconfigure.eventbus.JobEventCacheConfiguration;
import io.elasticjob.lite.api.dataflow.DataflowJob;
import io.elasticjob.lite.api.script.ScriptJob;
import io.elasticjob.lite.api.simple.SimpleJob;
import io.elasticjob.lite.config.JobCoreConfiguration;
import io.elasticjob.lite.config.JobTypeConfiguration;
import io.elasticjob.lite.config.LiteJobConfiguration;
import io.elasticjob.lite.config.dataflow.DataflowJobConfiguration;
import io.elasticjob.lite.config.script.ScriptJobConfiguration;
import io.elasticjob.lite.config.simple.SimpleJobConfiguration;
import io.elasticjob.lite.event.rdb.JobEventRdbConfiguration;
import io.elasticjob.lite.executor.handler.JobProperties;
import io.elasticjob.lite.reg.zookeeper.ZookeeperRegistryCenter;
import io.elasticjob.lite.spring.api.SpringJobScheduler;
import io.elasticjob.lite.spring.job.util.AopTargetUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class ElasticJobConfParser
implements ApplicationContextAware {
    private Logger logger = LoggerFactory.getLogger(ElasticJobConfParser.class);
    private static String JOB_CONFIG_PREFIX = "elastic.job.config.";
    @Autowired
    private ZookeeperRegistryCenter zookeeperRegistryCenter;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private Environment environment;
    private Map<String, BeanDefinition> jobBeanDefinitionMap = new ConcurrentHashMap<String, BeanDefinition>();
    private volatile boolean started = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener(value={ContextRefreshedEvent.class})
    @Order(value=0x7FFFFFFF)
    public void onContextRefreshed(ContextRefreshedEvent event) {
        if (event.getApplicationContext() == this.applicationContext) {
            if (this.started) {
                return;
            }
            try {
                DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)this.applicationContext.getAutowireCapableBeanFactory();
                try {
                    this.jobBeanDefinitionMap.forEach((beanId, beanDefinition) -> {
                        defaultListableBeanFactory.registerBeanDefinition(beanId, beanDefinition);
                        SpringJobScheduler springJobScheduler = (SpringJobScheduler)this.applicationContext.getBean(beanId);
                    });
                }
                catch (Exception e) {
                    this.logger.error("Init job failed", (Throwable)e);
                    System.exit(1);
                }
                this.jobBeanDefinitionMap.clear();
            }
            finally {
                this.started = true;
            }
        }
    }

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        Map beanMap = ctx.getBeansWithAnnotation(ElasticJob.class);
        for (Map.Entry entry : beanMap.entrySet()) {
            SimpleJobConfiguration typeConfig;
            Object confBean = entry.getValue();
            Object aopTargetObject = confBean;
            while (AopTargetUtils.getTarget(aopTargetObject) != aopTargetObject) {
                aopTargetObject = AopTargetUtils.getTarget(aopTargetObject);
            }
            ElasticJob conf = (ElasticJob)AnnotationUtils.findAnnotation(aopTargetObject.getClass(), ElasticJob.class);
            String jobClass = aopTargetObject.getClass().getName();
            String jobName = conf.name();
            String cron = this.getEnvironmentStringValue(jobName, "cron", conf.cron());
            String shardingItemParameters = this.getEnvironmentStringValue(jobName, "shardingItemParameters", conf.shardingItemParameters());
            String description = conf.description();
            String jobParameter = this.getEnvironmentStringValue(jobName, "jobParameter", conf.jobParameter());
            String jobExceptionHandler = conf.jobExceptionHandler();
            String executorServiceHandler = conf.executorServiceHandler();
            String jobShardingStrategyClass = conf.jobShardingStrategyClass();
            String eventTraceRdbDataSource = conf.eventTraceRdbDataSource();
            String scriptCommandLine = this.getEnvironmentStringValue(jobName, "scriptCommandLine", conf.scriptCommandLine());
            boolean failover = this.getEnvironmentBooleanValue(jobName, "failover", conf.failover());
            boolean misfire = this.getEnvironmentBooleanValue(jobName, "misfire", conf.misfire());
            boolean overwrite = this.getEnvironmentBooleanValue(jobName, "overwrite", conf.overwrite());
            boolean disabled = this.getEnvironmentBooleanValue(jobName, "disabled", conf.disabled());
            boolean monitorExecution = this.getEnvironmentBooleanValue(jobName, "monitorExecution", conf.monitorExecution());
            boolean streamingProcess = this.getEnvironmentBooleanValue(jobName, "streamingProcess", conf.streamingProcess());
            int shardingTotalCount = this.getEnvironmentIntValue(jobName, "shardingTotalCount", conf.shardingTotalCount());
            int monitorPort = conf.monitorPort();
            int maxTimeDiffSeconds = this.getEnvironmentIntValue(jobName, "maxTimeDiffSeconds", conf.maxTimeDiffSeconds());
            int reconcileIntervalMinutes = this.getEnvironmentIntValue(jobName, "reconcileIntervalMinutes", conf.reconcileIntervalMinutes());
            JobCoreConfiguration coreConfig = JobCoreConfiguration.newBuilder((String)jobName, (String)cron, (int)shardingTotalCount).shardingItemParameters(shardingItemParameters).description(description).failover(failover).jobParameter(jobParameter).misfire(misfire).jobProperties(JobProperties.JobPropertiesEnum.JOB_EXCEPTION_HANDLER.getKey(), jobExceptionHandler).jobProperties(JobProperties.JobPropertiesEnum.EXECUTOR_SERVICE_HANDLER.getKey(), executorServiceHandler).build();
            if (confBean instanceof SimpleJob) {
                typeConfig = new SimpleJobConfiguration(coreConfig, jobClass);
            } else if (confBean instanceof DataflowJob) {
                typeConfig = new DataflowJobConfiguration(coreConfig, jobClass, streamingProcess);
            } else if (confBean instanceof ScriptJob) {
                typeConfig = new ScriptJobConfiguration(coreConfig, scriptCommandLine);
            } else {
                throw new IllegalStateException("@ElasticJobConf must be annotated on a class which is sub class of io.elasticjob.lite.api.simple.SimpleJob or io.elasticjob.lite.api.dataflow.DataflowJob or io.elasticjob.lite.api.script.ScriptJob");
            }
            LiteJobConfiguration jobConfig = LiteJobConfiguration.newBuilder((JobTypeConfiguration)typeConfig).overwrite(overwrite).disabled(disabled).monitorPort(monitorPort).monitorExecution(monitorExecution).maxTimeDiffSeconds(maxTimeDiffSeconds).jobShardingStrategyClass(jobShardingStrategyClass).reconcileIntervalMinutes(reconcileIntervalMinutes).build();
            List<BeanDefinition> elasticJobListeners = this.getTargetElasticJobListeners(conf);
            BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(SpringJobScheduler.class);
            factory.setInitMethodName("init");
            if (confBean instanceof ScriptJob) {
                factory.addConstructorArgValue(null);
            } else {
                factory.addConstructorArgValue(confBean);
            }
            factory.addConstructorArgReference("zookeeperRegistryCenterForElasticJob");
            factory.addConstructorArgValue((Object)jobConfig);
            if (StringUtils.hasText((String)eventTraceRdbDataSource)) {
                BeanDefinitionBuilder rdbFactory = BeanDefinitionBuilder.rootBeanDefinition(JobEventRdbConfiguration.class);
                rdbFactory.addConstructorArgReference(eventTraceRdbDataSource);
                factory.addConstructorArgValue((Object)rdbFactory.getBeanDefinition());
            } else {
                BeanDefinitionBuilder cacheFactory = BeanDefinitionBuilder.rootBeanDefinition(JobEventCacheConfiguration.class);
                factory.addConstructorArgValue((Object)cacheFactory.getBeanDefinition());
            }
            factory.addConstructorArgValue(elasticJobListeners);
            String beanId = jobName + "SpringJobScheduler";
            if (this.jobBeanDefinitionMap.containsKey(beanId) || this.applicationContext.containsBean(beanId)) {
                throw new IllegalStateException("\u540d\u79f0\u4e3a[" + jobName + "\u7684elastic-job\u91cd\u590d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4@ElasticJobConf\u4e2d\u7684name\u662f\u552f\u4e00\u7684!");
            }
            this.jobBeanDefinitionMap.put(beanId, (BeanDefinition)factory.getBeanDefinition());
        }
    }

    private List<BeanDefinition> getTargetElasticJobListeners(ElasticJob conf) {
        ManagedList result = new ManagedList(2);
        String listener = this.getEnvironmentStringValue(conf.name(), "listener", conf.listener());
        if (StringUtils.hasText((String)listener)) {
            BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition((String)listener);
            result.add(factory.getBeanDefinition());
        }
        String distributedListener = this.getEnvironmentStringValue(conf.name(), "distributedListener", conf.distributedListener());
        long startedTimeoutMilliseconds = this.getEnvironmentLongValue(conf.name(), "startedTimeoutMilliseconds", conf.startedTimeoutMilliseconds());
        long completedTimeoutMilliseconds = this.getEnvironmentLongValue(conf.name(), "completedTimeoutMilliseconds", conf.completedTimeoutMilliseconds());
        if (StringUtils.hasText((String)distributedListener)) {
            BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition((String)distributedListener);
            factory.addConstructorArgValue((Object)startedTimeoutMilliseconds);
            factory.addConstructorArgValue((Object)completedTimeoutMilliseconds);
            result.add(factory.getBeanDefinition());
        }
        return result;
    }

    private String getEnvironmentStringValue(String jobName, String fieldName, String defaultValue) {
        String key = JOB_CONFIG_PREFIX + jobName + "." + fieldName;
        String value = this.environment.getProperty(key);
        if (StringUtils.hasText((String)value)) {
            return value;
        }
        return defaultValue;
    }

    private int getEnvironmentIntValue(String jobName, String fieldName, int defaultValue) {
        String key = JOB_CONFIG_PREFIX + jobName + "." + fieldName;
        String value = this.environment.getProperty(key);
        if (StringUtils.hasText((String)value)) {
            return Integer.valueOf(value);
        }
        return defaultValue;
    }

    private long getEnvironmentLongValue(String jobName, String fieldName, long defaultValue) {
        String key = JOB_CONFIG_PREFIX + jobName + "." + fieldName;
        String value = this.environment.getProperty(key);
        if (StringUtils.hasText((String)value)) {
            return Long.valueOf(value);
        }
        return defaultValue;
    }

    private boolean getEnvironmentBooleanValue(String jobName, String fieldName, boolean defaultValue) {
        String key = JOB_CONFIG_PREFIX + jobName + "." + fieldName;
        String value = this.environment.getProperty(key);
        if (StringUtils.hasText((String)value)) {
            return Boolean.valueOf(value);
        }
        return defaultValue;
    }
}

