/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage.mysql.v1;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jooq.Record;
import org.jooq.TableField;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.internal.Nullable;
import zipkin2.storage.mysql.v1.PeekingIterator;
import zipkin2.storage.mysql.v1.Schema;
import zipkin2.storage.mysql.v1.internal.generated.tables.ZipkinAnnotations;
import zipkin2.storage.mysql.v1.internal.generated.tables.ZipkinSpans;

final class DependencyLinkV2SpanIterator
implements Iterator<Span> {
    final PeekingIterator<Record> delegate;
    final long traceIdHi;
    final long traceIdLo;

    DependencyLinkV2SpanIterator(PeekingIterator<Record> delegate, long traceIdHi, long traceIdLo) {
        this.delegate = delegate;
        this.traceIdHi = traceIdHi;
        this.traceIdLo = traceIdLo;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext() && (Long)this.delegate.peek().getValue(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID) == this.traceIdLo;
    }

    @Override
    public Span next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Record row = this.delegate.peek();
        long spanId = (Long)row.getValue(ZipkinSpans.ZIPKIN_SPANS.ID);
        boolean error = false;
        String lcService = null;
        String srService = null;
        String csService = null;
        String caService = null;
        String saService = null;
        String maService = null;
        String mrService = null;
        String msService = null;
        while (this.hasNext() && spanId == (Long)this.delegate.peek().getValue(ZipkinSpans.ZIPKIN_SPANS.ID)) {
            Record next = this.delegate.next();
            String key = DependencyLinkV2SpanIterator.emptyToNull(next, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY);
            String value = DependencyLinkV2SpanIterator.emptyToNull(next, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_SERVICE_NAME);
            if (key == null || value == null) continue;
            switch (key) {
                case "lc": {
                    lcService = value;
                    break;
                }
                case "ca": {
                    caService = value;
                    break;
                }
                case "cs": {
                    csService = value;
                    break;
                }
                case "ma": {
                    maService = value;
                    break;
                }
                case "mr": {
                    mrService = value;
                    break;
                }
                case "ms": {
                    msService = value;
                    break;
                }
                case "sa": {
                    saService = value;
                    break;
                }
                case "sr": {
                    srService = value;
                    break;
                }
                case "error": {
                    error = 6 == (Integer)next.get(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_TYPE);
                }
            }
        }
        if (caService == null) {
            caService = csService;
        }
        if (saService != null && saService.equals(caService)) {
            caService = null;
        }
        long parentId = Schema.maybeGet(row, ZipkinSpans.ZIPKIN_SPANS.PARENT_ID, 0L);
        Span.Builder result = Span.newBuilder().traceId(this.traceIdHi, this.traceIdLo).parentId(parentId).id(spanId);
        if (error) {
            result.putTag("error", "");
        }
        if (srService != null) {
            return result.kind(Span.Kind.SERVER).localEndpoint(DependencyLinkV2SpanIterator.ep(srService)).remoteEndpoint(DependencyLinkV2SpanIterator.ep(caService)).build();
        }
        if (saService != null) {
            Endpoint localEndpoint = DependencyLinkV2SpanIterator.ep(caService);
            if (localEndpoint == null) {
                localEndpoint = DependencyLinkV2SpanIterator.ep(lcService);
            }
            return result.kind((Span.Kind)(csService != null ? Span.Kind.CLIENT : null)).localEndpoint(localEndpoint).remoteEndpoint(DependencyLinkV2SpanIterator.ep(saService)).build();
        }
        if (csService != null) {
            return result.kind(Span.Kind.SERVER).localEndpoint(DependencyLinkV2SpanIterator.ep(caService)).build();
        }
        if (mrService != null) {
            return result.kind(Span.Kind.CONSUMER).localEndpoint(DependencyLinkV2SpanIterator.ep(mrService)).remoteEndpoint(DependencyLinkV2SpanIterator.ep(maService)).build();
        }
        if (msService != null) {
            return result.kind(Span.Kind.PRODUCER).localEndpoint(DependencyLinkV2SpanIterator.ep(msService)).remoteEndpoint(DependencyLinkV2SpanIterator.ep(maService)).build();
        }
        return result.build();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    static long traceIdHigh(PeekingIterator<Record> delegate) {
        return (Long)delegate.peek().getValue(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID_HIGH);
    }

    @Nullable
    static String emptyToNull(Record next, TableField<Record, String> field) {
        String result = (String)next.getValue(field);
        return result != null && !"".equals(result) ? result : null;
    }

    static Endpoint ep(@Nullable String serviceName) {
        return serviceName != null ? Endpoint.newBuilder().serviceName(serviceName).build() : null;
    }

    static final class ByTraceId
    implements Iterator<Iterator<Span>> {
        final PeekingIterator<Record> delegate;
        final boolean hasTraceIdHigh;
        long currentTraceIdHi;
        long currentTraceIdLo;

        ByTraceId(Iterator<Record> delegate, boolean hasTraceIdHigh) {
            this.delegate = new PeekingIterator<Record>(delegate);
            this.hasTraceIdHigh = hasTraceIdHigh;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Iterator<Span> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.currentTraceIdHi = this.hasTraceIdHigh ? DependencyLinkV2SpanIterator.traceIdHigh(this.delegate) : 0L;
            this.currentTraceIdLo = (Long)this.delegate.peek().getValue(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID);
            return new DependencyLinkV2SpanIterator(this.delegate, this.currentTraceIdHi, this.currentTraceIdLo);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

