/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage.mysql.v1;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.jooq.DSLContext;
import org.jooq.TableLike;
import org.jooq.exception.DataAccessException;
import zipkin2.storage.mysql.v1.DSLContexts;
import zipkin2.storage.mysql.v1.internal.generated.tables.ZipkinSpans;

final class HasRemoteServiceName {
    static final Logger LOG = Logger.getLogger(HasRemoteServiceName.class.getName());
    static final String MESSAGE = "zipkin_spans.remote_service_name doesn't exist, so queries for remote service names will return empty.\nExecute: ALTER TABLE zipkin_spans ADD `remote_service_name` VARCHAR(255);\nALTER TABLE zipkin_spans ADD INDEX `remote_service_name`;";

    HasRemoteServiceName() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean test(DataSource datasource, DSLContexts context) {
        try (Connection conn = datasource.getConnection();){
            DSLContext dsl = context.get(conn);
            dsl.select(ZipkinSpans.ZIPKIN_SPANS.REMOTE_SERVICE_NAME).from((TableLike)ZipkinSpans.ZIPKIN_SPANS).limit(1).fetchAny();
            boolean bl = true;
            return bl;
        }
        catch (DataAccessException e) {
            if (e.sqlState().equals("42S22")) {
                LOG.warning(MESSAGE);
                return false;
            }
            HasRemoteServiceName.problemReading((Exception)((Object)e));
            return false;
        }
        catch (RuntimeException | SQLException e) {
            HasRemoteServiceName.problemReading(e);
        }
        return false;
    }

    static void problemReading(Exception e) {
        LOG.log(Level.WARNING, "problem reading zipkin_spans.remote_service_name", e);
    }
}

