/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage.mysql.v1;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.Row2;
import org.jooq.SelectOffsetStep;
import org.jooq.TableField;
import org.jooq.impl.DSL;
import zipkin2.storage.mysql.v1.DSLContexts;
import zipkin2.storage.mysql.v1.HasErrorCount;
import zipkin2.storage.mysql.v1.HasIpv6;
import zipkin2.storage.mysql.v1.HasPreAggregatedDependencies;
import zipkin2.storage.mysql.v1.HasRemoteServiceName;
import zipkin2.storage.mysql.v1.HasTraceIdHigh;
import zipkin2.storage.mysql.v1.Pair;
import zipkin2.storage.mysql.v1.internal.generated.tables.ZipkinAnnotations;
import zipkin2.storage.mysql.v1.internal.generated.tables.ZipkinDependencies;
import zipkin2.storage.mysql.v1.internal.generated.tables.ZipkinSpans;

final class Schema {
    final List<Field<?>> spanIdFields;
    final List<Field<?>> spanFields;
    final List<Field<?>> annotationFields;
    final List<Field<?>> dependencyLinkerFields;
    final List<Field<?>> dependencyLinkerGroupByFields;
    final List<Field<?>> dependencyLinkFields;
    final boolean hasTraceIdHigh;
    final boolean hasPreAggregatedDependencies;
    final boolean hasIpv6;
    final boolean hasErrorCount;
    final boolean hasRemoteServiceName;
    final boolean strictTraceId;

    Schema(DataSource datasource, DSLContexts context, boolean strictTraceId) {
        this.hasTraceIdHigh = HasTraceIdHigh.test(datasource, context);
        this.hasPreAggregatedDependencies = HasPreAggregatedDependencies.test(datasource, context);
        this.hasIpv6 = HasIpv6.test(datasource, context);
        this.hasErrorCount = HasErrorCount.test(datasource, context);
        this.hasRemoteServiceName = HasRemoteServiceName.test(datasource, context);
        this.strictTraceId = strictTraceId;
        this.spanIdFields = Schema.list(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID_HIGH, ZipkinSpans.ZIPKIN_SPANS.TRACE_ID);
        this.spanFields = Schema.list(ZipkinSpans.ZIPKIN_SPANS.fields());
        this.spanIdFields.remove(ZipkinSpans.ZIPKIN_SPANS.REMOTE_SERVICE_NAME);
        this.annotationFields = Schema.list(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.fields());
        this.dependencyLinkFields = Schema.list(ZipkinDependencies.ZIPKIN_DEPENDENCIES.fields());
        this.dependencyLinkerFields = Schema.list(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID_HIGH, ZipkinSpans.ZIPKIN_SPANS.TRACE_ID, ZipkinSpans.ZIPKIN_SPANS.PARENT_ID, ZipkinSpans.ZIPKIN_SPANS.ID, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_TYPE, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_SERVICE_NAME);
        this.dependencyLinkerGroupByFields = new ArrayList(this.dependencyLinkerFields);
        this.dependencyLinkerGroupByFields.remove(ZipkinSpans.ZIPKIN_SPANS.PARENT_ID);
        if (!this.hasTraceIdHigh) {
            this.spanIdFields.remove(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID_HIGH);
            this.spanFields.remove(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID_HIGH);
            this.annotationFields.remove(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID_HIGH);
            this.dependencyLinkerFields.remove(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID_HIGH);
            this.dependencyLinkerGroupByFields.remove(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID_HIGH);
        }
        if (!this.hasIpv6) {
            this.annotationFields.remove(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_IPV6);
        }
        if (!this.hasErrorCount) {
            this.dependencyLinkFields.remove(ZipkinDependencies.ZIPKIN_DEPENDENCIES.ERROR_COUNT);
        }
    }

    Condition joinCondition(ZipkinAnnotations annotationTable) {
        if (this.hasTraceIdHigh) {
            return ZipkinSpans.ZIPKIN_SPANS.TRACE_ID_HIGH.eq(annotationTable.TRACE_ID_HIGH).and(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID.eq(annotationTable.TRACE_ID)).and(ZipkinSpans.ZIPKIN_SPANS.ID.eq(annotationTable.SPAN_ID));
        }
        return ZipkinSpans.ZIPKIN_SPANS.TRACE_ID.eq(annotationTable.TRACE_ID).and(ZipkinSpans.ZIPKIN_SPANS.ID.eq(annotationTable.SPAN_ID));
    }

    static <T> List<T> list(T ... elements) {
        return new ArrayList<T>(Arrays.asList(elements));
    }

    Condition spanTraceIdCondition(SelectOffsetStep<? extends Record> traceIdQuery) {
        if (this.hasTraceIdHigh && this.strictTraceId) {
            Result result = traceIdQuery.fetch();
            ArrayList<Row2> traceIds = new ArrayList<Row2>(result.size());
            for (Record r : result) {
                traceIds.add(DSL.row((Object)r.get(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID_HIGH), (Object)r.get(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID)));
            }
            return DSL.row(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID_HIGH, ZipkinSpans.ZIPKIN_SPANS.TRACE_ID).in(traceIds);
        }
        List traceIds = traceIdQuery.fetch(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID);
        return ZipkinSpans.ZIPKIN_SPANS.TRACE_ID.in((Collection)traceIds);
    }

    Condition spanTraceIdCondition(long traceIdHigh, long traceIdLow) {
        return traceIdHigh != 0L && this.hasTraceIdHigh ? DSL.row(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID_HIGH, ZipkinSpans.ZIPKIN_SPANS.TRACE_ID).eq((Object)traceIdHigh, (Object)traceIdLow) : ZipkinSpans.ZIPKIN_SPANS.TRACE_ID.eq((Object)traceIdLow);
    }

    Condition spanTraceIdCondition(Set<Pair> traceIds) {
        return this.traceIdCondition(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID_HIGH, ZipkinSpans.ZIPKIN_SPANS.TRACE_ID, traceIds);
    }

    Condition annotationsTraceIdCondition(Set<Pair> traceIds) {
        return this.traceIdCondition(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID_HIGH, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID, traceIds);
    }

    Condition traceIdCondition(TableField<Record, Long> TRACE_ID_HIGH, TableField<Record, Long> TRACE_ID, Set<Pair> traceIds) {
        Object[] result;
        boolean hasTraceIdHigh = false;
        for (Pair traceId : traceIds) {
            if (traceId.left == 0L) continue;
            hasTraceIdHigh = true;
            break;
        }
        if (hasTraceIdHigh && this.strictTraceId) {
            result = new Row2[traceIds.size()];
            int i = 0;
            for (Pair traceId128 : traceIds) {
                result[i++] = DSL.row((Object)traceId128.left, (Object)traceId128.right);
            }
            return DSL.row(TRACE_ID_HIGH, TRACE_ID).in((Row2[])result);
        }
        result = new Long[traceIds.size()];
        int i = 0;
        for (Pair traceId128 : traceIds) {
            result[i++] = traceId128.right;
        }
        return TRACE_ID.in(result);
    }

    static <T> T maybeGet(Record record, TableField<Record, T> field, T defaultValue) {
        if (record.fieldsRow().indexOf(field) < 0) {
            return defaultValue;
        }
        Object result = record.get(field);
        return (T)(result != null ? result : defaultValue);
    }
}

