package cn.com.duiba.activity.center.api.remoteservice.ngame;

import cn.com.duiba.activity.center.api.dto.ngame.NgameConsumerRecordDto;

import java.util.List;
import java.util.Map;

public interface RemoteNgameConsumerRecordService {

	public NgameConsumerRecordDto findRecordByConIdAndNgameId(Long consumerId, Long duibaNgameId);

	public List<NgameConsumerRecordDto> findGameConfigDuibaScoreByDesc(Long duibaNgameId, Integer number);
	public List<NgameConsumerRecordDto> findGameConfigDuibaScoreByAsc(Long duibaNgameId, Integer number);
	
	public List<NgameConsumerRecordDto> findConsumerGameConfigDuibaScoreByDesc(Long duibaNgameId, Integer number);
	public List<NgameConsumerRecordDto> findConsumerGameConfigDuibaScoreByAsc(Long duibaNgameId, Integer number);

	public NgameConsumerRecordDto insert(NgameConsumerRecordDto gameConsumerRecordDO);

	public Integer updateScore(Long id, Long score, String autoOpenPrizeId, Long gameOrderId);

	public Integer updateScoreAndTotalScore(Long id, Long score, Integer shareScore, String autoOpenPrizeId, Long gameOrderId);

	public Integer updateTotalScore(Long id, Integer shareScore);

	public Integer updateIsGivePrize(Long id, Boolean isGivePrize);

	public Integer updateAutoOpenPrizeId(Long id, String autoOpenPrizeId);

	public void markCheat(Long id, Boolean cheat);
	
	public List<NgameConsumerRecordDto> findByConsumerAndIds(Long consumerId, List<Long> ids);

	List<NgameConsumerRecordDto> findTopWinning(Map<String, Object> params);

	List<NgameConsumerRecordDto> findTopWinningAsc(Map<String, Object> params);

	Integer countCheatBefore(Integer limit, Long gameConfigDuibaId);

	Integer countTopWinning(Map<String, Object> params);

	NgameConsumerRecordDto find(Long id);

	void setCheatReason(Long id, String cheatReason);

	public List<NgameConsumerRecordDto> findShareConsumerByGameConfigDuibaId(Long duibaNgameId);
	public int updateByGameConfigShare(Long id, Long duibaNgameId, Long shareScore);
	NgameConsumerRecordDto findByConsumerIdAndGameConfigDuibaId(Long consumerId, Long gameConfigDuibaId);

}
