package cn.com.duiba.activity.center.api.dto.ngame;

import java.io.Serializable;
import java.util.Date;

public class DuibaNgameDto implements Serializable {

    public static final String SHARE                  = "SHARE";
    public static final String PREVIEW                = "PREVIEW";

    private static final long  serialVersionUID       = -7929455156171928827L;
    public static final int    STATUS_NOCOMPLETE      = 0;                    // 数据不完整
    public static final int    STATUS_OPEN            = 1;                    // 开启且可见
    public static final int    STATUS_CLOSE_SHOW      = 2;                    // 关闭且可见
    public static final int    STATUS_CLOSE           = 3;                    // 关闭不可见

    public static final String LimitTypeForever       = "forever";            // 永久
    public static final String LimitTypeEveryday      = "everyday";           // 每天

    public static final int    SWITCHES_DIRECT        = 0;                     // 定向发放
    public static final int    SWITCHES_DEV_BLACKLIST = 1;                     // 黑名单
    public static final int    SWITCHES_FREE_RULE     = 2;                    // 免费次数使用的活动规则
	public static final int SWITCHES_UNOPEN = 3; // 无大奖模式
	
	//Start guoeryang,直充类奖品防刷,2016/06/14
    public static final Integer SWITCHES_ANTICHEAT_LIMIT_RULE = 4; // 开启直充类奖品防刷
    //End guoeryang,直充类奖品防刷,2016/06/14

    public static final int    TYPE_SANTA             = 1;                     // 打劫圣诞老人
    public static final int    TYPE_YEAR_AWARD        = 2;                     // 数年终奖
    public static final int    TYPE_GIRL              = 3;                     // 女神PK女汉子游戏

    public final static int    santa_max_time         = 600;                   // 圣诞老人最大游戏时间 （秒）
    public final static int    yearAward_max_time     = 63;                    // 年终奖最大游戏时间 （秒）

    public final static int    eachNum                = 5;                     // 数年终奖每秒最大滑动张数

    private Long               id;
    private String             title;
    private Integer            gameStatus;
    private Integer            creditsPrice;
    private Integer            freeLimit;
    private String             freeScope;
    private Integer            limitCount;
    private String             limitScope;
    private Long               duibaGameBrickId;
    private String             rule;
    private Integer            shareScores;
    private String             shareApp;
    private String             banner;
    private String             smallImage;
    private String             whiteImage;
    private String             logo;
    private Boolean            isOpenPrize;
    private Integer            switches;
    private Date               autoOffDate;
    private Boolean            deleted;
    private Date               gmtCreate;
    private Date               gmtModified;
    private String             freeRule;
    /* 奖项的json字符串 */
    private String             optionsJson;
    // 是否开启定向
    private Boolean            openSpecify;
    // 是否开启黑名单
    private Boolean            openBlack;
    // 免费
    private Boolean            openFreeRule;
    // double
    private Double             dCreditsPrice;

    private String             recommendImage;
	private Integer unopen;

	private Long activityCategoryId; //活动归类 --徐恒飞
	private Boolean anticheatLimit;

	public Boolean getAnticheatLimit() {
		return anticheatLimit;
	}
	public void setAnticheatLimit(Boolean anticheatLimit) {
		this.anticheatLimit = anticheatLimit;
	}

    public Integer getGameStatus() {
        return gameStatus;
    }

    public void setGameStatus(Integer gameStatus) {
        this.gameStatus = gameStatus;
    }

    public Long getDuibaGameBrickId() {
        return duibaGameBrickId;
    }

    public void setDuibaGameBrickId(Long duibaGameBrickId) {
        this.duibaGameBrickId = duibaGameBrickId;
    }

    public String getRule() {
        return rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public String getBanner() {
        return banner;
    }

    public void setBanner(String banner) {
        this.banner = banner;
    }

    public String getWhiteImage() {
        return whiteImage;
    }

    public void setWhiteImage(String whiteImage) {
        this.whiteImage = whiteImage;
    }

    public Double getdCreditsPrice() {
        return dCreditsPrice;
    }

    public void setdCreditsPrice(Double dCreditsPrice) {
        this.dCreditsPrice = dCreditsPrice;
    }

    public String getShareApp() {
        return shareApp;
    }

    public void setShareApp(String shareApp) {
        this.shareApp = shareApp;
    }

    public Boolean getOpenSpecify() {
        return openSpecify;
    }

    public void setOpenSpecify(Boolean openSpecify) {
        this.openSpecify = openSpecify;
    }

    public Boolean getOpenBlack() {
        return openBlack;
    }

    public void setOpenBlack(Boolean openBlack) {
        this.openBlack = openBlack;
    }

    public String getOptionsJson() {
        return optionsJson;
    }

    public void setOptionsJson(String optionsJson) {
        this.optionsJson = optionsJson;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getCreditsPrice() {
        return creditsPrice;
    }

    public void setCreditsPrice(Integer creditsPrice) {
        this.creditsPrice = creditsPrice;
    }

    public Integer getFreeLimit() {
        return freeLimit;
    }

    public void setFreeLimit(Integer freeLimit) {
        this.freeLimit = freeLimit;
    }

    public String getFreeScope() {
        return freeScope;
    }

    public void setFreeScope(String freeScope) {
        this.freeScope = freeScope;
    }

    public Integer getLimitCount() {
        return limitCount;
    }

    public void setLimitCount(Integer limitCount) {
        this.limitCount = limitCount;
    }

    public String getLimitScope() {
        return limitScope;
    }

    public void setLimitScope(String limitScope) {
        this.limitScope = limitScope;
    }

    public Integer getShareScores() {
        return shareScores;
    }

    public void setShareScores(Integer shareScores) {
        this.shareScores = shareScores;
    }

    public String getSmallImage() {
        return smallImage;
    }

    public void setSmallImage(String smallImage) {
        this.smallImage = smallImage;
    }

    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public Boolean getIsOpenPrize() {
        return isOpenPrize;
    }

    public void setIsOpenPrize(Boolean isOpenPrize) {
        this.isOpenPrize = isOpenPrize;
    }

    public Integer getSwitches() {
        return switches;
    }

    public void setSwitches(Integer switches) {
        this.switches = switches;
    }

    public Date getAutoOffDate() {
        return autoOffDate;
    }

    public void setAutoOffDate(Date autoOffDate) {
        this.autoOffDate = autoOffDate;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public void openSwitch(int s) {
        int v = 1 << s;
        switches = switches | v;
    }

    public void closeSwitch(int s) {
        int v = 1 << s;
        v = ~v;
        switches = switches & v;
    }

    public boolean isOpenSwitch(int s) {
        int v = 1 << s;
        int ret = switches & v;
        return ret != 0;
    }

    public String getFreeRule() {
        return freeRule;
    }

    public void setFreeRule(String freeRule) {
        this.freeRule = freeRule;
    }

    public Boolean getOpenFreeRule() {
        return openFreeRule;
    }

    public void setOpenFreeRule(Boolean openFreeRule) {
        this.openFreeRule = openFreeRule;
    }

    public String getRecommendImage() {
        return recommendImage;
    }

    public void setRecommendImage(String recommendImage) {
        this.recommendImage = recommendImage;
    }

    public Long getActivityCategoryId() {
        return activityCategoryId;
    }

    public void setActivityCategoryId(Long activityCategoryId) {
        this.activityCategoryId = activityCategoryId;
    }
    
    public Integer getUnopen() {
        return unopen;
    }
    
    public void setUnopen(Integer unopen) {
        this.unopen = unopen;
    }
}
