/**
 * Project Name:activity-center-api
 * File Name:AdActivityDto.java
 * Package Name:cn.com.duiba.activity.center.api.dto.advertising
 * Date:2016年10月11日上午11:23:48
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.api.dto.advertising;

import java.io.Serializable;

/**
 * ClassName:AdActivityDto <br/>
 * 商业广告dto，提供给广告平台的接口用
 * Date:     2016年10月11日 上午11:23:48 <br/>
 * @author   wubo
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class AdActivityDto implements Serializable{

    private static final long serialVersionUID = -3971192179032405845L;
    private Long activityId;            //活动id
    private Integer activityType;       //活动类型，OperatingActivityDto定义
    
    private String adMaterialTitle;     //推广标题
    private String adDescribe;          //广告描述
    private String adMaterialImg;       //活动图片(json格式，包含图片url，图片长，宽)
    
    private Long operatingActivityId;   //上架活动id
    private String activityUrl;         //活动URL
    
    public Long getActivityId() {
        return activityId;
    }
    
    public String keyGenerator(Long activityId,Integer activityType){
        return "adCache-"+activityId+"-"+activityType;
    }
    
    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }
    
    public Integer getActivityType() {
        return activityType;
    }
    
    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }
    
    public String getAdMaterialTitle() {
        return adMaterialTitle;
    }
    
    public void setAdMaterialTitle(String adMaterialTitle) {
        this.adMaterialTitle = adMaterialTitle;
    }
    
    public String getAdDescribe() {
        return adDescribe;
    }
    
    public void setAdDescribe(String adDescribe) {
        this.adDescribe = adDescribe;
    }
    
    public String getAdMaterialImg() {
        return adMaterialImg;
    }
    
    public void setAdMaterialImg(String adMaterialImg) {
        this.adMaterialImg = adMaterialImg;
    }
    
    public Long getOperatingActivityId() {
        return operatingActivityId;
    }
    
    public void setOperatingActivityId(Long operatingActivityId) {
        this.operatingActivityId = operatingActivityId;
    }
    
    public String getActivityUrl() {
        return activityUrl;
    }
    
    public void setActivityUrl(String activityUrl) {
        this.activityUrl = activityUrl;
    }
}

