package cn.com.duiba.activity.center.api.dto.creditgame;

/**
 * Created by Ansoya on 2016/11/11.
 */
public class DeveloperConsumeFailedExceptionDto extends Exception {

    private static final long serialVersionUID = -3452319566458382726L;
    private String code;
    private Boolean normalFail;//是否正常的消费积分失败  true正常的开发者返回失败，fasle服务器异常。

    public static final int FailTypeDefault = 1; // 其他
    public static final int FailTypebizId = 2; // 订单号重复
    public static final int FailTypeJson = 3; // json
    public static final int ConsumerCreditsType = 1;//用户积分扣除接口

    private String url;
    private String devRespone;
    private Integer failType;
    private Integer interfaceType;

    public DeveloperConsumeFailedExceptionDto(Throwable throwable) {
        super(throwable);
    }

    public DeveloperConsumeFailedExceptionDto(String message,Throwable throwable) {
        super(message,throwable);
    }


    public DeveloperConsumeFailedExceptionDto(String message,Boolean normalFail) {
        super(message);
        this.normalFail=normalFail;
        this.failType=FailTypeDefault;
    }
    public DeveloperConsumeFailedExceptionDto(String message,Boolean normalFail,Integer failType) {
        super(message);
        this.normalFail=normalFail;
        this.failType=failType;
    }

    public DeveloperConsumeFailedExceptionDto(String message,Throwable throwable,Boolean normalFail,Integer failType) {
        super(message,throwable);
        this.failType=failType;
        this.normalFail=normalFail;
    }

    public DeveloperConsumeFailedExceptionDto(String message,Throwable throwable,Boolean normalFail,Integer failType, Integer interfaceType,String devRespone,String url) {
        super(message,throwable);
        this.url=url;
        this.devRespone=devRespone;
        this.failType=failType;
        this.interfaceType=interfaceType;
        this.normalFail=normalFail;
    }


    public DeveloperConsumeFailedExceptionDto(String code, String msg) {
        super(msg);
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public Boolean getNormalFail() {
        return normalFail;
    }

    public void setNormalFail(Boolean normalFail) {
        this.normalFail = normalFail;
    }


    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDevRespone() {
        return devRespone;
    }

    public void setDevRespone(String devRespone) {
        this.devRespone = devRespone;
    }

    public Integer getFailType() {
        return failType;
    }

    public void setFailType(Integer failType) {
        this.failType = failType;
    }

    public Integer getInterfaceType() {
        return interfaceType;
    }

    public void setInterfaceType(Integer interfaceType) {
        this.interfaceType = interfaceType;
    }
}
