package cn.com.duiba.activity.center.api.remoteservice.elasticgifts;

import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsDto;
import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsTermDto;
import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticTakeOrderDto;
import cn.com.duiba.activity.center.api.dto.elasticgifts.RequestParamsDto;
import cn.com.duiba.activity.center.api.enums.ElasticGiftsBizCodeEnum;
import cn.com.duiba.dcommons.domain.Tuple;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 弹层礼包接口,手机端用
 */
public interface RemoteElasticGiftsService {

    /**
     * 获取app 对应的礼包活动以及活动项
     * @param appId
     * @return
     */
    DubboResult<Tuple.Tuple2<ElasticGiftsDto, List<ElasticGiftsTermDto>>> getElasticGiftsForMobile(ElasticGiftsBizCodeEnum bizCode, Long appId);

    /**
     * 下子订单,返回子订单 id
     * @param dto
     * @param itemId
     * @param consumerId
     * @param ip
     * @return
     */
    DubboResult<String> takeOrder(ElasticGiftsDto dto, Long itemId, Long appId, Long consumerId, RequestParamsDto requestParams);

    /**
     * 下单校验
     * @param egTermId
     * @param appId
     * @return
     */
    DubboResult<ElasticTakeOrderDto> checkElasticTakeOrder(Long egTermId, Long appId);
}
