package cn.com.duiba.activity.center.api.remoteservice.hdtool;

import cn.com.duiba.activity.center.api.dto.DeveloperActivityStatisticsDto;
import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolOrdersDto;

import java.util.List;
import java.util.Map;

/**
 * hdtool_orders表的app维度分表,活动工具订单业务DAO
 */
public interface RemoteAppHdtoolOrdersService {

	/**
	 * 根据ID查询订单
	 */
	public HdtoolOrdersDto find(Long appId, Long id);

	/**
	 * 根据开发者订单号查询订单
	 */
	public HdtoolOrdersDto findByAppAndDeveloperBizId(Long appId, String bizId);

	/**
	 * 统计活动失败条数
	 */
	public List<DeveloperActivityStatisticsDto> countFailByOperatingActivityIds(Long appId, List<Long> ids);
	
	/**
	 * 分页查询
	 */
	public List<HdtoolOrdersDto> findByLimit(Map<String, Object> queryParam);
	
	/**
	 * 统计条数
	 */
	public Long totalCount(Map<String, Object> queryParam);

	/**
	 * 根据活动订单ID集合查询订单信息
	 */
	public List<HdtoolOrdersDto> findByIds(Long appId, List<Long> ids);

	public List<HdtoolOrdersDto> findHdtoolOrderLimit50(Long appId, Long activityId);

}
