/**
 * Project Name:activity-center-api
 * File Name:TodayRobShowEntranceEnum.java
 * Package Name:cn.com.duiba.activity.center.api.enums
 * Date:2016年11月14日下午2:02:48
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * 秒杀区间展示入口枚举<br/>
 * Date:     2016年11月14日 下午2:02:48 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public enum SeckillShowEntranceEnum implements EnumInterface {
    /** 今日必抢入口 */
    TODAY_ROB("todayRob", "今日必抢入口"),

    /** 秒杀楼层入口 */
    FLOOR("floor", "秒杀楼层入口");
    
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    private SeckillShowEntranceEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static SeckillShowEntranceEnum getByCode(String code) {
        for (SeckillShowEntranceEnum enumVal : SeckillShowEntranceEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDesc() {
        return desc;
    }
}

