package cn.com.duiba.activity.center.api.remoteservice.gamecommon;


import cn.com.duiba.activity.center.api.dto.common.CustomerGameAppDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * describe : 用户游戏关联表，通过customer_id和game_id关联记录用户所拥有的游戏，以及最近在玩的游戏。
 * @author  : cdm
 * @date    : 2016年10月13日 下午4:16:33
 */
public interface RemoteCustomerGameAppService {
	
	
	/**
	 * describe : 根据用户ID，游戏ID，appID获取用户的游戏记录信息,没有就新增后返回
	 * @author  : cdm
	 * @date    : 2016年10月13日下午4:19:43
	 * @param GameId       游戏ID
	 * @param customerId   用户ID
	 * @param appId        appID
	 */
    DubboResult<CustomerGameAppDto> getDtoByGameIdAndCustomerId(Long gameId, Long customerId, Long appId,Long gameType);
    
    
    /**
     * describe : 更新用户游戏记录
     * @author  : cdm
     * @date    : 2016年10月13日下午4:22:24
     * @param gameId        游戏ID
     * @param customerId    用户ID
     * @param appId         应用ID
     * @param bestRecord    最佳分
     * @param rank          排名
     */
    DubboResult<Boolean> updateRecod(Long gameId, Long customerId, Long appId,Long bestRecord, Long rank);

    /**
     * describe : 更新用户授权信息
     * @author  : cdm
     * @date    : 2016年10月13日下午4:22:24
     * @param GameId       游戏ID
	 * @param customerId   用户ID
	 * @param appId        appID
     */
    DubboResult<Boolean> updateIsBuy(Long gameId, Long customerId, Long appId);

	/**
     * describe : 增加用户app游戏记录
     * @author  : cdm
     * @date    : 2016年10月13日下午4:22:24
     * @param GameId       游戏ID
	 * @param customerId   用户ID
	 * @param appId        appID
	 * @param isBuy        是否购买
     */
    //DubboResult<Long>  save(CustomerGameAppDto customerGameAppDto);
}

