package cn.com.duiba.activity.center.api.remoteservice.guess;


import cn.com.duiba.activity.center.api.dto.guess.DuibaGuessOptionsDto;

import java.util.List;
import java.util.Map;

public interface RemoteDuibaGuessOptionsService {
	
	public List<DuibaGuessOptionsDto> findByGuessId(Long guessId);
	public Map<Long, List<DuibaGuessOptionsDto>> findByGuessIds(List<Long> guessIds);
	
	public DuibaGuessOptionsDto findById(Long id);
	
	public List<DuibaGuessOptionsDto> findByAutoOpen(Long guessId, boolean autoOpen);
	
	public List<DuibaGuessOptionsDto> findByAutoOpenAsc(Long guessId, boolean autoOpen);


	//from manager
	public int delete(List<Long> ids);
	public DuibaGuessOptionsDto insert(DuibaGuessOptionsDto duibaGuessOptionsDto);
	public int updateInfoForm(DuibaGuessOptionsDto duibaGuessOptionsDto);

	/**
	 * 更新库存
	 */
	public int updateRemainingById(Long id, Integer remaining);
	
}
