package cn.com.duiba.activity.center.api.remoteservice.guess;

import cn.com.duiba.activity.center.api.dto.guess.GuessOrdersDto;

import java.util.Date;
import java.util.List;

/**
 * Created by yansen on 16/7/18.
 */
public interface RemoteGuessOrdersConsumerService {
    public GuessOrdersDto find(Long consumerId , Long guessOrderId);

    public Integer countByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId);

    public Integer countByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end);

    public Integer countFreeByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long id, Date start, Date end);

    public Integer countFreeByConsumerIdAndOperatingActivityId(Long consumerId, Long id);

    public List<GuessOrdersDto> findByIds(Long consumerId, List<Long> ids);

    public List<GuessOrdersDto> findWinOrders(Long consumerId, Long duibaGuessId);

    public List<GuessOrdersDto> findGuessOrders(Long consumerId, Long duibaGuessId);

    public int updateStatusToSuccess(Long consumerId,Long guessOrderId, Long guessOrderExtraId);

    public int updateStatusToFail(Long consumerId,Long guessOrderId, String error4admin, String error4developer, String error4consumer);

    public int updateExchangeStatusToWaitOpen(Long consumerId,Long guessOrderId);

    public int updateExchangeStatusToWaitOpenAndExtraId(Long consumerId,Long guessOrderId, Long guessOrderExtraId);

    public int updateExchangeStatusToWait(Long consumerId,Long gameOrderId, Long itemId, Long appItemId, Long prizeId, String prizeType, String prizeName, String prizeFacePrice, Long couponId);

    public int updateExchangeStatusToFail(Long consumerId,Long gameOrderId, String error4admin, String error4developer, String error4consumer);

    public int doTakePrize(Long consumerId,Long gameOrderId);

    public int rollbackTakePrize(Long consumerId,Long gameOrderId);

    public int updateManualOpenPrizeExchangeStatusToWait(Long consumerId,Long gameOrderId, Long itemId, Long appItemId, Long prizeId, String prizeType, String prizeName, String prizeFacePrice, Long couponId);

    public int updateIsGivePrize(Long consumerId, Long id, int b);
    /**
     * 修改订单领奖状态为过期失效
     */
    public int updateExchangeStatusToOverdue(Long consumerId,long id, String error4admin, String error4developer, String error4consumer) ;

    public int updateStatusToConsumeSuccess(Long consumerId, Long gameOrderId);

    public int updateExchangeStatusToWaitOpenAndExtraIdForLuck(Long consumerId, Long gameOrderId, Long guessOrderExtraId);

    /**
     * 添加竞猜订单
     */
    public GuessOrdersDto insert(GuessOrdersDto guessOrdersDto);

    public int updateDeveloperBizId(Long consumerId,long id, String bizId);

    public int updateMainOrderId(Long consumerId,long id, Long mainOrderId, String mainOrderNum);

}
