package cn.com.duiba.activity.center.api.remoteservice.plugin;

import java.util.List;

import cn.com.duiba.activity.center.api.dto.activity_brick.PopupActivityBrickDto;
import cn.com.duiba.activity.center.api.dto.plugin.ActivityPluginDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/** 
 * ClassName:RemoteActivityPluginService.java <br/>
 * @author  gey 
 * @date 创建时间：2016年10月13日 下午4:09:53 
 * @version 1.0 
 * @parameter  
 * @since   JDK 1.6
 */
public interface RemoteActivityPluginService {

	/**
	 * 查询插件活动list
	 * 
	 * @return 操作结果
	 */
	DubboResult<List<ActivityPluginDto>> findActivityPluginInfoList();

	/**
	 * 根据Id查询签到皮肤
	 * @param Integer id
	 * @return 签到皮肤
	 */
	DubboResult<PopupActivityBrickDto> findBrickById(Long id);

	/**
	 * 根据Id查询插件活动
	 * @param 签到编辑
	 * @return 操作结果
	 */
	DubboResult<ActivityPluginDto> findById(Long id);
	
	/**
	 * 生成订单  出奖
	 * @param 签到编辑
	 * @return 操作结果
	 */
	DubboResult<String> createOrder(Long consumerId,String transfer,String ip,String description,String ua,String os,ActivityPluginDto pluDto);
	
	/**
	 * 根据Id开启插件活动配置
	 * @param id 签到ID
	 * @return 操作结果
	 */
	DubboResult<Integer> updateStatus(Long id,Integer value);

}