package cn.com.duiba.activity.center.api.remoteservice.rob.category;

import cn.com.duiba.activity.center.api.dto.rob.category.RobBarCategoryRelationDto;
import cn.com.duiba.activity.center.api.dto.rob.category.RobCategoryBarDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 功能描述:今日必抢分类栏service相关接口
 *
 * @author sunchangji
 * @date 2016/10/18
 */
public interface RemoteRobCategoryBarService {

    /**
     * 根据分类栏名称分页查询分类栏信息，
     * 如果分类栏名称为空则查询的是全部信息
     *
     * @param name     分类栏名称(模糊匹配)
     * @param offset   偏移量
     * @param pageSize 页距
     * @return
     */
    DubboResult<List<RobCategoryBarDto>> getPagByName(String name, Integer offset, Integer pageSize);

    /**
     * 根据分类栏name分页查询分类栏总记录数
     *
     * @param name 分类栏名称，不传查询全部记录数
     * @return
     */
    public DubboResult<Integer> countByName(String name);

    /**
     * 逻辑步骤：
     * 1.根据分类栏id删除分类栏与应用关联表相关数据
     * 2.根据分类栏id删除分类栏与分类关联表数据
     * 3.根据分类id删除分类栏数据
     * 4.把分类栏对应的app分类列表缓存置失效
     *
     * @param barId 分类栏id
     * @return
     */
    DubboResult<Boolean> deleteBarById(Long barId);


    /**
     * 新增分类栏
     *
     * @param name         分类栏名称
     * @param relationDtos 分类栏对应的分类关联数据(分类id,排序值)
     * @return
     */
    DubboResult<Boolean> insertRobCategoryBar(String name, List<RobBarCategoryRelationDto> relationDtos);

    /**
     * 根据分类栏id查询分类栏信息
     *
     * @param barId 分类id
     * @return
     */
    DubboResult<RobCategoryBarDto> getRobCategoryBarById(Long barId);

    /**
     * 根据分类栏id查询该分类栏下所有分类id，结果是按排序的
     *
     * @param barId 分类栏id
     * @return
     */
    DubboResult<List<Long>> getRobCategoryIdsBarById(Long barId);

    /**
     * 查询全部分类栏列表
     *
     * @return
     */
    DubboResult<List<RobCategoryBarDto>> getAllCategoryBarList();


    /**
     * 更新分类栏
     *
     * @param barId        分类栏id
     * @param name         分类栏名称
     * @param relationDtos 关联分类数据
     * @return
     */
    DubboResult<Boolean> updateCategoryBar(Long barId, String name, List<RobBarCategoryRelationDto> relationDtos);
}
