package cn.com.duiba.activity.center.api.remoteservice.seckill;

import cn.com.duiba.activity.center.api.dto.seckill.DuibaSeckillAppSpecifyDto;
import cn.com.duiba.wolf.dubbo.dispatcher.RunInExecutor;

import java.util.List;
import java.util.Map;

public interface RemoteDuibaSeckillAppSpecifyService {
	/**
	 * 根据appId查询定向的活动id列表
	 *
	 * @author zhanglihui
	 * @param appId
	 * @return
	 * @since JDK 1.6
	 */
	List<Long> findActivityIdsByAppId(Long appId);

	public DuibaSeckillAppSpecifyDto find(Long id);

	public void delete(Long id);

	public DuibaSeckillAppSpecifyDto insert(DuibaSeckillAppSpecifyDto duibaSeckillAppSpecify);

	public List<DuibaSeckillAppSpecifyDto> findByDuibaSeckillId(Long duibaSeckillId);

	public DuibaSeckillAppSpecifyDto findByDuibaSeckillAndApp(Long duibaSeckillId, Long appId);

	public Map<Long, DuibaSeckillAppSpecifyDto> findByDuibaSeckillsAndApp(List<Long> duibaSeckillIds, Long appId);
}
