package cn.com.duiba.activity.center.api.remoteservice.seckill;

import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;
import cn.com.duiba.activity.center.api.dto.seckill.DuibaSeckillDto;

import java.util.List;
import java.util.Map;

public interface RemoteDuibaSeckillServiceNew {

	/**
	 * 批量查询秒杀活动
	 *
	 * @author zhanglihui
	 * @param ids
	 * @return
	 * @since JDK 1.6
	 */
	List<DuibaSeckillDto> findAllOpenedByIds(List<Long> ids);

	public DuibaSeckillDto insert(DuibaSeckillDto duibaSeckillDO);
	public List<DuibaSeckillDto> findByPage(Map<String, Object> queryMap);
	public Long findPageCount();
	public Long findPageCount(Map<String, Object> queryMap);
	public DuibaSeckillDto find(Long id);
	public String findTagById(Long id);
	public List<DuibaSeckillDto> findEffective();
	public int updateStatus(Long id, int status);
	public int updateTagById(Long id, String tag);
	public int delete(Long id);
	public int updateAutoOffDateNull(Long id);
	public int updateInfoForm(DuibaSeckillDto duibaSeckillDO);

	public void updateSwitches(Long id, Long switches);
	
	/**
	 * 查询秒杀活动列表.<br>
	 * 【查询参数】
	 * <ol>
	 * <li>offset:查询的开始位置处</li>
	 * <li>max:偏移量</li>
	 * <li>activityName:title名称(支持模糊查询)</li>
	 * <li>activityId:秒杀活动ID</li>
	 * </ol>
	 *
	 * @param queryMap 查询参数
	 * @param List<DuibaSeckillDto> 秒杀活动概要信息
	 *
	 */
	public List<DuibaSeckillDto> findByMap(Map<String, Object> paramMap);

	public List<DuibaSeckillDto> findAllByIds(List<Long> ids);

	public List<AddActivityDto> findAllSeckill(Long appId);

	public void update(DuibaSeckillDto DO);

}
