package cn.com.duiba.activity.center.api.remoteservice.seckill;


import cn.com.duiba.activity.center.api.dto.seckill.DuibaSeckillStockConfigDto;

import java.util.Date;
import java.util.List;

public interface RemoteDuibaSeckillStockConfigService {

	DuibaSeckillStockConfigDto find(Long id);

	DuibaSeckillStockConfigDto findByUnique(Long skillId, Long appId);

	int consumeStock(Long id);


	public DuibaSeckillStockConfigDto insert(DuibaSeckillStockConfigDto config);

	public List<DuibaSeckillStockConfigDto> findBySeckillId(Long seckillId);

	public int getStockConfigMaxPayload(Long seckillId);

	public List<DuibaSeckillStockConfigDto> findBySeckillIdAndAppIds(Long seckillId, List<Long> appIds);
	/**
	 * 重新启用被删除的子库存
	 * @param config
	 * @return
	 */
	public int invocationStockConfig(DuibaSeckillStockConfigDto config);

	public void markDelStockConfig(DuibaSeckillStockConfigDto config);

	public void setDay(Long configId, Date day);

	public int setPayload(Long configId, Integer payload);
	
}
