package cn.com.duiba.activity.center.api.remoteservice.seckill;

import cn.com.duiba.activity.center.api.dto.seckill.DuibaSeckillDto;
import cn.com.duiba.activity.center.api.dto.seckill.DuibaSeckillStockDto;
import cn.com.duiba.service.exception.BusinessException;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Optional;

import java.util.List;

/**
 * Created by wenqi.huang on 2016/11/21.
 */
public interface RemoteDuibaSeckillStockService {

    /**
     * 根据活动Id找库存
     * @param id
     * @return
     */
    public DuibaSeckillStockDto findBySeckillId(Long id);

    /**
     * 创建库存
     * @param seckillId
     * @throws BusinessException
     */
    public void createSeckillStock(Optional<Long> seckillId) throws BusinessException;

    /**
     * 修改总库存
     * @param seckillId
     * @param quantity
     * @throws BusinessException
     */
    public void editTotalStock(Long seckillId,Integer quantity) throws BusinessException;

    public void batchCreateStockConfig(Long seckillId,List<Long> appIds) throws BusinessException;

    public void deleteStockConfig(Long seckillId,Long appId) throws BusinessException;

    public void saveTotalConfigs(Long seckillId,List<JSONObject> configList) throws BusinessException;

    public void flushConfigStock(DuibaSeckillDto seckill, boolean needFlushDay);

}
