package cn.com.duiba.activity.center.api.remoteservice.chaos;

import cn.com.duiba.activity.center.api.dto.chaos.ActPreStockDto;

import java.util.List;

/**
 * Created by yansen on 16/6/22.
 */
public interface RemoteActPreStockService {
    /**
     * 
     * addAppActPreStock:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param configId
     * @param prizeId
     * @param quantity
     * @param name
     * @param relationType
     * @param appId
     * @since JDK 1.6
     */
    public void addAppActPreStock(Long configId, Long prizeId, Long quantity, String name, String relationType, Long appId);

    /**
     * 
     * addShareActPreStock:(这里用一句话描述这个方法的作用). <br/>
     * 新增共享预分配库存
     * @param configId
     * @param prizeId
     * @param quantity
     * @param name
     * @param relationType
     * @since JDK 1.6
     */
    public void addShareActPreStock(Long configId, Long prizeId, Long quantity, String name, String relationType);

    /**
     * 
     * refreshActPreStock:(这里用一句话描述这个方法的作用). <br/>
     * 刷新共享预分配库存
     * @param prizeId
     * @param relationType
     * @param appId
     * @param quantity
     * @param name
     * @return
     * @since JDK 1.6
     */
    public int refreshActPreStock(Long prizeId, String relationType, Long appId, Long quantity, String name);

    /**
     * 
     * deleteActStock:(这里用一句话描述这个方法的作用). <br/>
     * 删除活动，则删除
     * @param configId
     * @param relationType
     * @return
     * @since JDK 1.6
     */
    public int deleteActStock(Long configId, String relationType);

    /**
     * 删除活动的奖品
     *
     * @param configId
     * @param prizeId
     * @param relationType
     * @return
     */
    public int deleteActPrizeStock(Long configId, Long prizeId, String relationType);

    /**
     * 
     * deleteActStockAppId:(这里用一句话描述这个方法的作用). <br/>
     * 删除appId
     * @param prizeId
     * @param relationType
     * @param appId
     * @return
     * @since JDK 1.6
     */
    public int deleteActStockAppId(Long prizeId, String relationType, Long appId);

    /**
     * 查询预分配库存
     *
     * @param prizeId
     * @param relationType
     * @param appId
     * @return
     */
    public ActPreStockDto findPreStock(Long prizeId, String relationType, Long appId);

    /**
     * 查询预分配库存,根据配置id
     *
     * @param configId
     * @param relationType
     * @return
     */
    public List<ActPreStockDto> findPreStock(Long configId, String relationType);

    /**
     * 根据奖品类型及id查询活动预分配定向库存
     *
     * @param relationPrizeId
     * @param relationType
     * @param appId
     * @return
     */
    public ActPreStockDto findPreStockByApp(Long relationPrizeId, String relationType, Long appId);
    
    /**
     * 根据奖品类型及id查询活动预分配定向库存
     *
     * @param relationPrizeIds
     * @param relationType
     * @param appId
     * @return List<ActPreStockDto>
     */
    public List<ActPreStockDto> findPreStockListByApp(List<Long> relationPrizeIds, String relationType, Long appId);

    /**
     * 根据奖品类型及id查询活动预分配共享库存
     *
     * @param relationPrizeId
     * @param relationType
     * @return
     */
    public ActPreStockDto findPreStockByShare(Long relationPrizeId, String relationType);

    /**
     * 加锁查询
     *
     * @param id
     * @return
     */
    public ActPreStockDto findByLock(Long id);

    /**
     * 减库存
     *
     * @param id
     * @return
     */
    public int decrementRemaining(Long id);

    /**
     * 返库存
     *
     * @param id
     * @return
     */
    public int incrementRemaining(Long id);

    /**
     * 加库存
     *
     * @param id
     * @param addRemaining
     * @return
     */
    public int addRemainingById(Long id, Long addRemaining);

    /**
     * 减库存
     *
     * @param id
     * @param subRemaining
     * @return
     */
    public int subRemainingById(Long id, Long subRemaining);

    /**
     * 插入记录
     *
     * @param actPreStockDO
     */
    public ActPreStockDto insert(ActPreStockDto actPreStockDO);

    /**
     * 更新记录
     *
     * @param actPreStockDO
     */
    public int update(ActPreStockDto actPreStockDO);

    /**
     * 
     * findActStockByConfigId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param configId
     * @param relationType
     * @return
     * @since JDK 1.6
     */
    public List<ActPreStockDto> findActStockByConfigId(Long configId, String relationType);
}
