/**
 * Project Name:activity-center-biz
 * File Name:SignConfigDao.java
 * Package Name:cn.com.duiba.activity.center.biz.dao.sign
 * Date:2016年10月22日下午1:33:58
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.api.remoteservice.sign;

import java.util.List;

import cn.com.duiba.activity.center.api.dto.sign.SignConfigDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:SignConfigDao <br/>
 * Date:     2016年10月22日 下午1:33:58 <br/>
 * @author   liyang
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteSignConfigService {
    /**
     * 
     * findAllByIds:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param ids
     * @return
     * @since JDK 1.6
     */
    List<SignConfigDto> findAllByIds(List<Long> ids);
    /**
     * 
     * findByPage:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appId
     * @param offset
     * @param max
     * @param title
     * @param id
     * @return
     * @since JDK 1.6
     */
    List<SignConfigDto> findByPage(Long appId, Integer offset, Integer max, String title, Integer id);
    /**
     * 
     * findByPageCount:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appId
     * @param title
     * @param id
     * @return
     * @since JDK 1.6
     */
    Long findByPageCount(Long appId, String title, Integer id);
    /**
     * 
     * find:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    SignConfigDto find(Long id);
    /**
     * 
     * add:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param sign
     * @return
     * @since JDK 1.6
     */
    SignConfigDto add(SignConfigDto sign);
    
    /**
     * 
     * delete:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @since JDK 1.6
     */
    void delete(Long id);
    /**
     * 
     * update:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param sign
     * @since JDK 1.6
     */
    void update(SignConfigDto sign);
    
    /**
     * 
     * updateStatus:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @param status
     * @return
     * @since JDK 1.6
     */
    int updateStatus(Long id, Integer status);
    
    /**
     * 
     * createOrder:(这里用一句话描述这个方法的作用). <br/>
     * 生成订单  出奖
     * @param consumerId
     * @param transfer
     * @param ip
     * @param description
     * @param ua
     * @param os
     * @param signDto
     * @param signDays
     * @param addCredits
     * @return
     * @since JDK 1.6
     */
    DubboResult<String> createOrder(Long consumerId,String transfer,String ip,String description,String ua,String os,SignConfigDto signDto, Integer signDays, Long addCredits);
    
    /**
     * 
     * addCreditsAgain:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param orderNum
     * @param appId
     * @param consumerId
     * @param transfer
     * @param ip
     * @param description
     * @param ua
     * @param os
     * @param signDto
     * @param signDays
     * @param addCredits
     * @return
     * @since JDK 1.6
     */
    public DubboResult<String> addCreditsAgain(String orderNum,Long appId,Long consumerId, String transfer, String ip, String description, String ua,
                                               String os, SignConfigDto signDto, Integer signDays, Long addCredits);
}

