package cn.com.duiba.activity.center.api.dto.seconds_kill;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringUtils;

public class ItemsArea implements Comparable<ItemsArea>,Serializable{

	private static final long serialVersionUID = 5747386046804719282L;
	private int index;

	private String title;

	private Date killtime;
	
	private String killhour;
	/**
	 * true:已抢光
	 * false:未抢光
	 */
	private boolean isLoot;
	private List<Long> itemIds;

	public ItemsArea() {
	}

	public ItemsArea(int index, String title, Date killtime, List<Long> itemIds,String killhour) {
		this.index = index;
		this.title = title;
		this.killtime = killtime;
		this.killhour = killhour;
		this.itemIds = itemIds;
	}
	
	public int getIndex() {
		return index;
	}

	public void setIndex(int index) {
		this.index = index;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Date getKilltime() {
		return killtime;
	}

	public void setKilltime(Date killtime) {
		this.killtime = killtime;
	}
	
	public boolean isLoot() {
		return isLoot;
	}

	public void setLoot(boolean isLoot) {
		this.isLoot = isLoot;
	}

	public String getKillhour() {
		return killhour;
	}

	public void setKillhour(String killhour) {
		this.killhour = killhour;
	}

	public List<Long> getItemIds() {
		return itemIds;
	}

	public void setItemIds(List<Long> itemIds) {
		this.itemIds = itemIds;
	}

	@Override
	public int compareTo(ItemsArea o) {
		if(this.killhour!=null && StringUtils.isNotBlank(this.killhour)){
			if(this.isLoot != o.isLoot){
				//根据是否已抢光排序
				if(!this.isLoot && o.isLoot ) 
					return -1;
				else
					return 1;
			}else{
				//根据抽奖时间点排序
				if( Integer.parseInt(this.killhour) < Integer.parseInt(o.getKillhour()))
					return -1;
				else if ( Integer.parseInt(this.killhour) > Integer.parseInt(o.getKillhour()))
					return 1;
				else return 0;
			}
		}else {
			if (this.index < o.index) {
				return -1;
			}
			if (this.index > o.index) {
				return 1;
			}
			return 0;
		}
	}

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
    
    

}
