/**
 * Project Name:activity-center-api
 * File Name:RemoteTodayRobConfigService.java
 * Package Name:cn.com.duiba.activity.center.api.remoteservice.rob
 * Date:2016年7月25日下午3:21:30
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.api.remoteservice.rob;

import java.util.List;
import java.util.Map;
import cn.com.duiba.activity.center.api.dto.rob.TodayRobConfigDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteTodayRobConfigService <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年7月25日 下午3:21:30 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteTodayRobConfigService {
    
    /**
     * 根据id查询
     * @author zp
     * @param configId
     * @return
     * @since JDK 1.6
     */
    public DubboResult<TodayRobConfigDto> find(Long configId);
    
    /**
     * 编辑/保存
     * id为空则为保存，id有值则为编辑
     * saveOrUpdateTodayRobConfig:<br/>
     * @author zp
     * @param todayRobConfigDto
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Long> saveOrUpdateTodayRobConfig(TodayRobConfigDto todayRobConfigDto);
    
    /**
     * 分页查询
     * params参数为:
     * offset:分页起始(必填)
     * pageSize:每页显示多少条(必填)
     * id: 根据活动id搜索
     * name:活动名称
     * title:活动标题
     * @author zp
     * @param params
     * @return
     * @since JDK 1.6
     */
    public DubboResult<List<TodayRobConfigDto>> findTodayRobConfigPage(Map<String,Object> params);
    
    /**
     * 分页count
     * @author zp
     * @param params
     * offset:分页起始(必填)
     * pageSize:每页显示多少条(必填)
     * id: 根据活动id搜索
     * name:活动名称
     * title:活动标题
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Integer> findTodayRobConfigCount(Map<String,Object> params);
    
    /**
     * 活动置顶排序
     * @author zp
     * @param offset
     * @param pageSize
     * @return
     * @since JDK 1.6
     */
    public DubboResult<List<TodayRobConfigDto>> findSortTodayRobConfig(Integer offset,Integer pageSize);
    
    /**
     * 删除活动
     * @author zp
     * @param configId
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Boolean> delTodayRobConfig(Long configId);
    
    /**
     * 状态改变
     * @author zp
     * @param configId
     * @param status
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Boolean> statusChange(Long configId,Integer status);
    
    /**
     * 置顶
     * @author zp
     * @param id
     * @param switches
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Boolean> accessSticky(Long id);
    
    /**
     * 取消置顶
     * @author zp
     * @param id
     * @param switches
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Boolean> cancelSticky(Long id);
    
    /**
     * 砍价接口
     * @author zp
     * @param TodayShoppingId
     * @param activityType
     * @param consumerId
     * @param ip
     * @param ua
     * @return
     * @since JDK 1.6
     */
    public DubboResult<String> cutPrice(Long todayRobConfigId,String activityType,Long consumerId, String ip, String ua,String transfer);
}

