/**
 * Project Name:activity-center-api
 * File Name:RemoteActivityPrizeOptionService.java
 * Package Name:cn.com.duiba.activity.center.api.remoteservice.prize
 * Date:2016年7月26日上午11:08:42
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.api.remoteservice.prize;

import java.util.List;

import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteActivityPrizeOptionService <br/>
 * Date:     2016年7月26日 上午11:08:42 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteActivityPrizeOptionService {

    /**
     * 根据id查询奖项
     * @author zp
     * @param id
     * @return
     * @since JDK 1.6
     */
    public DubboResult<ActivityPrizeOptionDto> find(Long id);
    
    /**
     * 删除奖项
     * @author zp
     * @param optionId
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Boolean> delOption(Long optionId);
    
    /**
     * 保存/编辑奖项
     * @author zp
     * @param prizeOption
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Long> saveOrUpdateOption(ActivityPrizeOptionDto prizeOption);
    
    /**
     * 根据活动id查询奖项
     * queryActivityOptionsByConfigId:(这里用一句话描述这个方法的作用). <br/>
     * @author zp
     * @param configId
     * @return
     * @since JDK 1.6
     */
    public DubboResult<List<ActivityPrizeOptionDto>> queryActivityOptionsByConfigId(Long configId,String activityType);
    
    /**
     * 根据活动id 批量查询奖项
     * queryActivityOptionsByConfigIds. <br/>
     *
     * @author wubo
     * @param configIds
     * @param activityType
     * @return
     * @since JDK 1.6
     */
    public DubboResult<List<ActivityPrizeOptionDto>> queryActivityOptionsByConfigIds(List<Long> configIds,String activityType);
    
    /**
     * 根据活动类型查询
     * queryActivityOptionByActivityType <br/>
     *
     * @author wubo 
     * @param activityType
     * @return
     * @since JDK 1.6
     */
    public DubboResult<List<ActivityPrizeOptionDto>> queryActivityOptionByActivityType(String activityType,Integer offset,Integer max);
    
    /**
     * queryCountByActivityType:(查询某活动类型的个数)<br/>
     * @author wubo
     * @param activityType
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Long> queryCountByActivityType(String activityType);
    
    /**
     * queryRandomGift:(随机查询一些礼包，可以过滤一些id). <br/>
     *
     * @author wubo
     * @param number 个数
     * @param ids 要过滤的id
     * @return
     * @since JDK 1.6
     */
    public DubboResult<List<ActivityPrizeOptionDto>> queryRandomGift(Integer number,List<Long> ids);
    
    
    
}

