package cn.com.duiba.activity.center.api.enums;

/**
 * 删除状态枚举
 */
public enum DeletedEnum {

    UNDELETED(0, "未删除"),
    DELETED(1, "删除");

    private int    value;
    private String desc;

    DeletedEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return this.value;
    }

    public String desc() {
        return this.desc;
    }

    public static DeletedEnum fromValue(int value) {
        for (DeletedEnum it : DeletedEnum.values()) {
            if (value == it.value()) {
                return it;
            }
        }
        return null;
    }
}
