package cn.com.duiba.activity.center.api.enums;

/**
 * 弹层礼包状态
 */
public enum ElasticGiftsStatusEnum {

    CLOSE_AND_UNVIEW(0, "关闭且不可见"),
    OPEN(1, "开启且可见"),
    CLOSE_AND_VIEW(2, "关闭且可见");

    private int    value;
    private String desc;

    ElasticGiftsStatusEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return this.value;
    }

    public String desc() {
        return this.desc;
    }

    public static ElasticGiftsStatusEnum fromValue(int value) {
        for (ElasticGiftsStatusEnum it : ElasticGiftsStatusEnum.values()) {
            if (value == it.value()) {
                return it;
            }
        }
        return null;
    }
}
