package cn.com.duiba.activity.center.api.remoteservice.elasticgifts;

import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsAppListDto;
import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsAppSaveResultDto;
import cn.com.duiba.activity.center.api.enums.ElasticGiftsBizCodeEnum;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 管理员后台,弹层活动 app 配置
 */
public interface RemoteElasticGiftsAppBackendService {

    /**
     * 获取所有的 app 配置列表
     * @param bizCode
     * @param activityId
     * @return
     */
    DubboResult<List<ElasticGiftsAppListDto>> getAllElasticGiftsApps(ElasticGiftsBizCodeEnum bizCode, Long activityId);

    /**
     * 删除
     * @param bizCode
     * @param appIds
     * @return
     */
    DubboResult<Boolean> delete(ElasticGiftsBizCodeEnum bizCode, List<Long> appIds);

    /**
     * 保存 app 配置
     * 会有一个比对操作和原来的做对比,原来没有的插,原来有的现在没有的删
     * @param bizCode
     * @param appIds
     * @param activityId
     * @return
     */
    DubboResult<List<ElasticGiftsAppSaveResultDto>> save(List<Long> toDeleteIds, ElasticGiftsBizCodeEnum bizCode, List<Long> appIds, Long activityId);

}
