package cn.com.duiba.activity.center.api.remoteservice.elasticgifts;

import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsTermDto;
import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsTermSimpleDto;
import cn.com.duiba.activity.center.api.enums.ElasticGiftsTermTypeEnum;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 管理员后台,礼包项接口
 */
public interface RemoteElasticGiftsTermBackendService {

    /**
     * 查询礼包项列表
     * @param elasticGiftsId
     * @return
     */
    DubboResult<List<ElasticGiftsTermSimpleDto>> getTermsByElasticGiftsId(Long elasticGiftsId);

    /**
     * 排序
     * 参数为新顺序
     * @param ids
     * @return
     */
    DubboResult<Boolean> sortTerms(List<Long> ids);

    /**
     * 删除礼包项
     * @param id
     * @return
     */
    DubboResult<Boolean> delete(Long id);

    /**
     * 保存礼包项
     * @param id
     * @param typeEnum
     * @param termId
     * @param title
     * @param subtitle
     * @param payIntro
     * @param btnText
     * @return
     */
    DubboResult<Boolean> save(Long id, ElasticGiftsTermTypeEnum typeEnum, Long termId, Long elasticGiftsId, String title, String subtitle, String payIntro, String btnText);

    /**
     * 获取 term
     * @param id
     * @return
     */
    DubboResult<ElasticGiftsTermDto> getTermById(Long id);
}
