/**
 * Project Name:activity-center-api
 * File Name:TodayRobConfigDto.java
 * Package Name:cn.com.duiba.activity.center.api.dto.rob
 * Date:2016年7月25日下午2:37:16
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.api.dto.rob;

import java.io.Serializable;
import java.util.Date;

/**
 * 今日必抢配置表
 * ClassName:TodayRobConfigDto <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年7月25日 下午2:37:16 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class TodayRobConfigDto implements Serializable{

    private static final long serialVersionUID = -6451105644893094901L;
    
    public static String ACTIVITY_TYPE_ROB = "rob";
    
    public static final Integer SWITCHES_DIRECT = 0;        // 定向发放
    public static final Integer SWITCHES_DEV_BLACKLIST = 1; // 黑名单商品
    public static final Integer SWITCHES_TOP = 2;           // 置顶
    
    public static final Integer STATUS_UNPUBLISH = 0;       // 关闭不可见
    public static final Integer STATUS_STARTUP = 1;         // 开启且可见
    public static final Integer STATUS_SHUTDOWN = 2;        // 关闭且可见
     
    public static final String DEFAULT_BEFORE_BARGAIN_BUTTON = "砍";
    public static final String DEFAULT_AFTER_BARGAIN_BUTTON = "抢";
    public static final String DEFAULT_BARGAIN_BUTTON = "砍一下";
    
    private Long id;
    private String name;//活动名称
    private String title;//活动标题
    private String subTitle;//活动副标题
    private Integer credits;//积分价值
    private Integer price;//市场价
    private Integer discountPrice;//优惠价
    private Integer bargainPrice;//砍后价
    private String buttonBefore;//砍前按钮文案
    private String buttonAfter;//砍后按钮文案
    private String buttonDetail;//砍价按钮文案
    private String description;//活动说明
    private String rateDescription;//概率说明
    private String smallImage;//缩略图
    private String images;//详细图多图
    private Date startTime;//活动开始时间
    private Date endTime;//活动结束时间
    private Integer status;//活动状态
    private Boolean deleted;//是否删除：0未删除 1已删除
    private Integer switches;
    private Integer visitTime;//参与次数
    private Date stickyTime;//置顶时间
    private Date gmtCreate;
    private Date gmtModified;
    
    public void openSwitch(int s) {
        int v = 1 << s;
        switches = switches | v;
    }

    public void closeSwitch(int s) {
        int v = 1 << s;
        v = ~v;
        switches = switches & v;
    }

    public boolean isOpenSwitch(int s) {
        int v = 1 << s;
        int ret = switches & v;
        return ret != 0;
    }
    
    public Long getId() {
        return id;
    }
    
    public void setId(Long id) {
        this.id = id;
    }
    
    public String getName() {
        return name;
    }
    
    public void setName(String name) {
        this.name = name;
    }
    
    public String getTitle() {
        return title;
    }
    
    public void setTitle(String title) {
        this.title = title;
    }
    
    public String getSubTitle() {
        return subTitle;
    }
    
    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }
    
    public Integer getCredits() {
        return credits;
    }
    
    public void setCredits(Integer credits) {
        this.credits = credits;
    }
    
    public Integer getPrice() {
        return price;
    }
    
    public void setPrice(Integer price) {
        this.price = price;
    }
    
    public Integer getDiscountPrice() {
        return discountPrice;
    }
    
    public void setDiscountPrice(Integer discountPrice) {
        this.discountPrice = discountPrice;
    }
    
    public Integer getBargainPrice() {
        return bargainPrice;
    }
    
    public void setBargainPrice(Integer bargainPrice) {
        this.bargainPrice = bargainPrice;
    }
    
    public String getButtonBefore() {
        return buttonBefore;
    }
    
    public void setButtonBefore(String buttonBefore) {
        this.buttonBefore = buttonBefore;
    }
    
    public String getButtonAfter() {
        return buttonAfter;
    }
    
    public void setButtonAfter(String buttonAfter) {
        this.buttonAfter = buttonAfter;
    }
    
    public String getButtonDetail() {
        return buttonDetail;
    }
    
    public void setButtonDetail(String buttonDetail) {
        this.buttonDetail = buttonDetail;
    }
    
    public String getDescription() {
        return description;
    }
    
    public void setDescription(String description) {
        this.description = description;
    }
    
    public String getRateDescription() {
        return rateDescription;
    }
    
    public void setRateDescription(String rateDescription) {
        this.rateDescription = rateDescription;
    }
    
    public String getSmallImage() {
        return smallImage;
    }
    
    public void setSmallImage(String smallImage) {
        this.smallImage = smallImage;
    }
    
    public String getImages() {
        return images;
    }
    
    public void setImages(String images) {
        this.images = images;
    }
    
    public Date getStartTime() {
        return startTime;
    }
    
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }
    
    public Date getEndTime() {
        return endTime;
    }
    
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }
    
    public Integer getStatus() {
        return status;
    }
    
    public void setStatus(Integer status) {
        this.status = status;
    }
    
    public Boolean getDeleted() {
        return deleted;
    }

    
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }
    
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }
    
    public Date getGmtModified() {
        return gmtModified;
    }
    
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Integer getSwitches() {
        return switches;
    }

    public void setSwitches(Integer switches) {
        this.switches = switches;
    }

    
    public Date getStickyTime() {
        return stickyTime;
    }

    public void setStickyTime(Date stickyTime) {
        this.stickyTime = stickyTime;
    }

    
    public Integer getVisitTime() {
        return visitTime;
    }
    
    public void setVisitTime(Integer visitTime) {
        this.visitTime = visitTime;
    }
    
}

