/**
 * Project Name:activity-center-api File Name:RemoteGameSkinService.java Package
 * Name:cn.com.duiba.activity.center.api.remoteservice.gameskin Date:2016年9月29日下午3:11:06 Copyright (c) 2016,
 * duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.activity.center.api.remoteservice.gameskin;

import java.util.List;
import cn.com.duiba.activity.center.api.dto.PagingParameters;
import cn.com.duiba.activity.center.api.dto.gameskin.GameSkinDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteGameSkinService <br/>
 * 游戏皮肤接口(积分游戏,小游戏公用) <br/>
 * Date: 2016年9月29日 下午3:11:06 <br/>
 * 
 * @author wubo
 * @version
 * @since JDK 1.6
 * @see
 */
public interface RemoteGameSkinService {

    DubboResult<GameSkinDto> find(Long id);

    DubboResult<List<GameSkinDto>> findPage(PagingParameters pagingParameters);

    DubboResult<List<GameSkinDto>> findByType(Byte type);

    DubboResult<Long> add(GameSkinDto dto);

    DubboResult<Long> edit(GameSkinDto dto);

    DubboResult<Boolean> isTitleExist(String name);

    DubboResult<Long> findCount();
}
