package cn.com.duiba.activity.center.api.dto.common;

import java.io.Serializable;
import java.util.Date;


/**
 * describe : 用户游戏关联表
 * @author  : cdm
 * @date    : 2016年10月13日 下午2:46:34
 */
public class CustomerGameAppDto  implements Serializable {

	private static final long serialVersionUID = 66486544211386844L;
	

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 用户ID
     */
    private Long customerId;

    /**
     * 游戏ID
     */
    private Long gameId;

    /**
     * appid 
     */
    private Long appId;
    

    /**
     * 是否购买   0：未购买   1：已购买   默认0
     */
    private int isBuy;

    /**
     * 当前游戏最佳成绩
     */
    private Long bestRecord;

    /**
     * 总试玩次数
     */
    private int tryNum;
    
    
    /**
     * 当天试玩次数
     */
    private int todayTryNum;

    /**
     * 记录创建时间
     */
    private Date gmtCreate;

    /**
     * 记录最后修改时间
     */
    private Date gmtModified;

    /**
     * 分享次数
     */
    private int shareNum;
    
    
    

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getCustomerId() {
		return customerId;
	}

	public void setCustomerId(Long customerId) {
		this.customerId = customerId;
	}

	public Long getGameId() {
		return gameId;
	}

	public void setGameId(Long gameId) {
		this.gameId = gameId;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public int getIsBuy() {
		return isBuy;
	}

	public void setIsBuy(int isBuy) {
		this.isBuy = isBuy;
	}

	public Long getBestRecord() {
		return bestRecord;
	}

	public void setBestRecord(Long bestRecord) {
		this.bestRecord = bestRecord;
	}

	public int getTryNum() {
		return tryNum;
	}

	public void setTryNum(int tryNum) {
		this.tryNum = tryNum;
	}

	public int getTodayTryNum() {
		return todayTryNum;
	}

	public void setTodayTryNum(int todayTryNum) {
		this.todayTryNum = todayTryNum;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public int getShareNum() {
		return shareNum;
	}

	public void setShareNum(int shareNum) {
		this.shareNum = shareNum;
	}
    
	public CustomerGameAppDto(Long id) {
		this.id = id;
		this.gmtModified = new Date();
	}

	public CustomerGameAppDto(boolean init4insert) {
		if (init4insert) {
			isBuy = 0;
			shareNum = 0;
			gmtCreate = new Date();
			gmtModified = new Date();
		}
	}
   
    
}