package cn.com.duiba.activity.center.api.remoteservice.common;


import cn.com.duiba.activity.center.api.dto.common.CustomerGameAppDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * describe : 用户游戏关联表，通过customer_id和game_id关联记录用户所拥有的游戏，以及最近在玩的游戏。
 * @author  : cdm
 * @date    : 2016年10月13日 下午4:16:33
 */
public interface RemoteCustomerGameAppService {
	
	
	/**
	 * describe : 根据用户ID，游戏ID，appID获取用户的游戏记录信息
	 * @author  : cdm
	 * @date    : 2016年10月13日下午4:19:43
	 * @param GameId       游戏ID
	 * @param customerId   用户ID
	 * @param appId        appID
	 */
    DubboResult<CustomerGameAppDto> getDtoByGameIdAndCustomerId(Long GameId, Long customerId,Long appId);
    
    
    /**
     * describe : 增加用户游戏记录
     * @author  : cdm
     * @date    : 2016年10月13日下午4:22:24
     * @param customerGameAppDto  用户游戏记录信息
     */
    DubboResult<Long> saveOrUpdate(CustomerGameAppDto customerGameAppDto);

	/**
     * describe : 根据ID删除用户游戏记录
     * @author  : cdm
     * @date    : 2016年10月13日下午4:22:24
     * @param id  用户游戏记录信息ID
     */
    DubboResult<Boolean> deleteById(Long id);

	/**
     * describe : 根据用户ID，游戏ID，appID  update用户购买信息
     * @author  : cdm
     * @date    : 2016年10月13日下午4:22:24
     * @param GameId       游戏ID
	 * @param customerId   用户ID
	 * @param appId        appID
	 * @param isBuy        是否购买
     */
    DubboResult<Boolean> updateBuyInfo(Long GameId, Long customerId,Long appId,int isBuy);
}

